/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;

@Rule(key="S134")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lorg/sonarsource/kotlin/checks/TooDeeplyNestedStatementsCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "max", "", "getMax", "()I", "setMax", "(I)V", "check", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "isElseIfStatement", "", "parent", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "tree", "isTernaryOperator", "nodeToHighlight", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitLoopExpression", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "Companion", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nTooDeeplyNestedStatementsCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooDeeplyNestedStatementsCheck.kt\norg/sonarsource/kotlin/checks/TooDeeplyNestedStatementsCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1559#2:135\n1590#2,4:136\n*S KotlinDebug\n*F\n+ 1 TooDeeplyNestedStatementsCheck.kt\norg/sonarsource/kotlin/checks/TooDeeplyNestedStatementsCheck\n*L\n97#1:135\n97#1:136,4\n*E\n"})
public final class TooDeeplyNestedStatementsCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="max", description="Maximum allowed control flow statement nesting depth", defaultValue="3")
    private int max = 3;
    public static final int DEFAULT_MAX_DEPTH = 3;

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int n) {
        this.max = n;
    }

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        this.check(expression2, kotlinFileContext);
    }

    @Override
    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(loopExpression, "loopExpression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        this.check(loopExpression, kotlinFileContext);
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        this.check(expression2, kotlinFileContext);
    }

    @Override
    public void visitTryExpression(@NotNull KtTryExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        this.check(expression2, kotlinFileContext);
    }

    /*
     * WARNING - void declaration
     */
    private final void check(KtExpression expression2, KotlinFileContext kotlinFileContext) {
        Object parent2;
        PsiElement psiElement = expression2.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getParent(...)");
        if (this.isElseIfStatement(psiElement, expression2)) {
            return;
        }
        if (this.isTernaryOperator(expression2)) {
            return;
        }
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParents(expression2).iterator();
        List nestedParentNodes = new ArrayList();
        Object last = expression2;
        while (iterator2.hasNext()) {
            parent2 = iterator2.next();
            if (this.isElseIfStatement((PsiElement)parent2, (PsiElement)last) && !((Collection)nestedParentNodes).isEmpty()) {
                CollectionsKt.removeLast(nestedParentNodes);
            }
            if (parent2 instanceof KtLoopExpression || parent2 instanceof KtTryExpression || parent2 instanceof KtIfExpression || parent2 instanceof KtWhenExpression) {
                nestedParentNodes.add((KtExpression)parent2);
            }
            if (nestedParentNodes.size() > this.max) {
                return;
            }
            last = parent2;
        }
        if (nestedParentNodes.size() == this.max) {
            Collection<SecondaryLocation> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            parent2 = nestedParentNodes;
            String string2 = "Refactor this code to not nest more than " + this.max + " control flow statements.";
            PsiElement psiElement2 = this.nodeToHighlight(expression2);
            KotlinFileContext kotlinFileContext2 = kotlinFileContext;
            AbstractCheck abstractCheck = this;
            boolean $i$f$mapIndexed = false;
            void var8_12 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void psiElement3;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                KtExpression ktExpression = (KtExpression)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, this.nodeToHighlight((KtExpression)psiElement3)), "Nesting depth " + (int)i));
            }
            collection = (List)destination$iv$iv;
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext2, psiElement2, string2, (List)collection, null, 8, null);
        }
    }

    private final PsiElement nodeToHighlight(KtExpression expression2) {
        PsiElement psiElement;
        KtExpression ktExpression = expression2;
        if (ktExpression instanceof KtLoopExpression) {
            PsiElement psiElement2 = ((KtLoopExpression)expression2).getFirstChild();
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue(psiElement2, "getFirstChild(...)");
        } else if (ktExpression instanceof KtTryExpression) {
            PsiElement psiElement3 = ((KtTryExpression)expression2).getTryKeyword();
            psiElement = psiElement3;
            Intrinsics.checkNotNull(psiElement3);
        } else if (ktExpression instanceof KtIfExpression) {
            PsiElement psiElement4 = ((KtIfExpression)expression2).getIfKeyword();
            psiElement = psiElement4;
            Intrinsics.checkNotNullExpressionValue(psiElement4, "getIfKeyword(...)");
        } else if (ktExpression instanceof KtWhenExpression) {
            PsiElement psiElement5 = ((KtWhenExpression)expression2).getWhenKeyword();
            psiElement = psiElement5;
            Intrinsics.checkNotNullExpressionValue(psiElement5, "getWhenKeyword(...)");
        } else {
            psiElement = expression2;
        }
        return psiElement;
    }

    private final boolean isTernaryOperator(KtExpression tree) {
        if (!(tree instanceof KtIfExpression) || ((KtIfExpression)tree).getElse() == null) {
            return false;
        }
        return !(((KtIfExpression)tree).getThen() instanceof KtBlockExpression) && !(((KtIfExpression)tree).getElse() instanceof KtBlockExpression) && !(((KtIfExpression)tree).getElse() instanceof KtIfExpression);
    }

    private final boolean isElseIfStatement(PsiElement parent2, PsiElement tree) {
        PsiElement p = parent2.getParent();
        return tree instanceof KtIfExpression && p instanceof KtIfExpression && Intrinsics.areEqual(tree, ((KtIfExpression)p).getElse());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/sonarsource/kotlin/checks/TooDeeplyNestedStatementsCheck$Companion;", "", "()V", "DEFAULT_MAX_DEPTH", "", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

