/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroupDifference;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfileDifference;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfileEditVersionComparisonUtils;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfileHistoryVersionComparison;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicatorDifference;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class AnalysisProfileEditVersionComparison {
    public static AnalysisProfileHistoryVersionComparison getAnalysisProfileComparison(AnalysisProfile oldProfile, AnalysisProfile newProfile) {
        if (newProfile == null || oldProfile == null) {
            return null;
        }
        List<String[]> changesOtherOptions = AnalysisProfileEditVersionComparisonUtils.getDifferenceInOptions(oldProfile.getOptions(), newProfile.getOptions(), Set.of());
        return AnalysisProfileEditVersionComparison.getAnalysisProfileHistoryVersionComparison(newProfile, oldProfile, changesOtherOptions);
    }

    private static AnalysisProfileHistoryVersionComparison getAnalysisProfileHistoryVersionComparison(AnalysisProfile newProfile, AnalysisProfile oldProfile, List<String[]> changesOtherOptions) {
        UnmodifiableList<QualityIndicator> newProfileQualityIndicators = newProfile.getQualityIndicators();
        UnmodifiableList<QualityIndicator> oldProfileQualityIndicators = oldProfile.getQualityIndicators();
        Set oldIndicatorNames = oldProfileQualityIndicators.stream().map(QualityIndicator::getName).collect(Collectors.toSet());
        HashSet<String> qualityIndicatorsUnchangedName = new HashSet<String>();
        for (QualityIndicator x : newProfileQualityIndicators) {
            if (!oldIndicatorNames.contains(x.getName())) continue;
            qualityIndicatorsUnchangedName.add(x.getName());
        }
        Set<QualityIndicator> unmatchedOldQualityIndicators = oldProfileQualityIndicators.stream().filter(indicator -> !qualityIndicatorsUnchangedName.contains(indicator.getName())).collect(Collectors.toSet());
        Set<QualityIndicator> unmatchedNewQualityIndicators = newProfileQualityIndicators.stream().filter(indicator -> !qualityIndicatorsUnchangedName.contains(indicator.getName())).collect(Collectors.toSet());
        ArrayList<String[]> qualityIndicatorRenames = new ArrayList<String[]>();
        List<QualityIndicatorDifference> qualityIndicatorDifferences = AnalysisProfileEditVersionComparison.getProfileQualityIndicatorDifferences(newProfile, oldProfileQualityIndicators, unmatchedOldQualityIndicators, unmatchedNewQualityIndicators, qualityIndicatorRenames);
        return AnalysisProfileEditVersionComparison.completeAnalysisProfileHistoryVersionComparison(newProfile, oldProfile, changesOtherOptions, unmatchedOldQualityIndicators, unmatchedNewQualityIndicators, qualityIndicatorRenames, qualityIndicatorDifferences);
    }

    private static List<QualityIndicatorDifference> getProfileQualityIndicatorDifferences(AnalysisProfile newProfile, UnmodifiableList<QualityIndicator> oldProfileQualityIndicators, Set<QualityIndicator> unmatchedOldQualityIndicators, Set<QualityIndicator> unmatchedNewQualityIndicators, List<String[]> qualityIndicatorRenames) {
        HashSet<QualityIndicator> matchedNew = new HashSet<QualityIndicator>();
        HashMap<String, String> matchNewIndicatorToOldName = new HashMap<String, String>();
        for (QualityIndicator unmatchedNew : unmatchedNewQualityIndicators) {
            Optional<QualityIndicator> match = AnalysisProfileEditVersionComparisonUtils.oldMatchedRename(unmatchedNew, unmatchedOldQualityIndicators);
            if (!match.isPresent()) continue;
            qualityIndicatorRenames.add(new String[]{match.get().getName(), unmatchedNew.getName()});
            matchNewIndicatorToOldName.put(unmatchedNew.getName(), match.get().getName());
            unmatchedOldQualityIndicators.remove(match.get());
            matchedNew.add(unmatchedNew);
        }
        unmatchedNewQualityIndicators.removeAll(matchedNew);
        return AnalysisProfileEditVersionComparison.getQualityIndicatorDifferences(newProfile, oldProfileQualityIndicators, unmatchedNewQualityIndicators, matchNewIndicatorToOldName);
    }

    private static AnalysisProfileHistoryVersionComparison completeAnalysisProfileHistoryVersionComparison(AnalysisProfile newProfile, AnalysisProfile oldProfile, List<String[]> changesOtherOptions, Set<QualityIndicator> unmatchedOldQualityIndicators, Set<QualityIndicator> unmatchedNewQualityIndicators, List<String[]> qualityIndicatorRenames, List<QualityIndicatorDifference> qualityIndicatorDifferences) {
        Set<ELanguage> languagesAdded = AnalysisProfileEditVersionComparisonUtils.getAdditionalEntries(newProfile.getLanguages(), oldProfile.getLanguages());
        Set<ELanguage> languagesRemoved = AnalysisProfileEditVersionComparisonUtils.getAdditionalEntries(oldProfile.getLanguages(), newProfile.getLanguages());
        Set<EAnalysisTool> toolsAdded = AnalysisProfileEditVersionComparisonUtils.getAdditionalEntries(newProfile.getTools(), oldProfile.getTools());
        Set<EAnalysisTool> toolsRemoved = AnalysisProfileEditVersionComparisonUtils.getAdditionalEntries(oldProfile.getTools(), newProfile.getTools());
        AnalysisProfileDifference analysisProfileDifference = new AnalysisProfileDifference(languagesAdded, languagesRemoved, toolsAdded, toolsRemoved, qualityIndicatorRenames, unmatchedNewQualityIndicators, unmatchedOldQualityIndicators, qualityIndicatorDifferences, changesOtherOptions, AnalysisProfileEditVersionComparisonUtils.getStringChanges(oldProfile.getDescription(), newProfile.getDescription()));
        Set<ELanguage> commonLanguages = AnalysisProfileEditVersionComparisonUtils.getAdditionalEntries(newProfile.getLanguages(), languagesAdded);
        Set<EAnalysisTool> commonTools = AnalysisProfileEditVersionComparisonUtils.getAdditionalEntries(newProfile.getTools(), toolsAdded);
        return new AnalysisProfileHistoryVersionComparison(analysisProfileDifference, commonLanguages, commonTools);
    }

    private static List<QualityIndicatorDifference> getQualityIndicatorDifferences(AnalysisProfile newProfile, UnmodifiableList<QualityIndicator> oldProfileQualityIndicators, Set<QualityIndicator> unmatchedNewQualityIndicators, Map<String, String> matchNewIndicatorToOldName) {
        ArrayList<QualityIndicatorDifference> qualityIndicatorDifferences = new ArrayList<QualityIndicatorDifference>();
        AnalysisProfileEditVersionComparison.computeQualityIndicatorsDifferences(newProfile, oldProfileQualityIndicators, unmatchedNewQualityIndicators, matchNewIndicatorToOldName, qualityIndicatorDifferences);
        return qualityIndicatorDifferences;
    }

    private static void computeQualityIndicatorsDifferences(AnalysisProfile newProfile, UnmodifiableList<QualityIndicator> oldProfileQualityIndicators, Set<QualityIndicator> unmatchedNewQualityIndicators, Map<String, String> matchNewIndicatorToOldName, List<QualityIndicatorDifference> qualityIndicatorDifferences) {
        for (QualityIndicator newIndicator : newProfile.getQualityIndicators()) {
            Optional<QualityIndicator> oldIndicatorOptional;
            if (unmatchedNewQualityIndicators.contains(newIndicator) || (oldIndicatorOptional = AnalysisProfileEditVersionComparison.getMatchingOldQualityIndicator(newIndicator, oldProfileQualityIndicators, matchNewIndicatorToOldName)).isEmpty()) continue;
            QualityIndicator oldIndicator = oldIndicatorOptional.get();
            AnalysisProfileEditVersionComparison.computeQualityIndicatorDifference(qualityIndicatorDifferences, newIndicator, oldIndicator);
        }
    }

    private static void computeQualityIndicatorDifference(List<QualityIndicatorDifference> qualityIndicatorDifferences, QualityIndicator newIndicator, QualityIndicator oldIndicator) {
        List<String[]> optionDiff = AnalysisProfileEditVersionComparisonUtils.getDifferenceInOptions(oldIndicator.getOptions(), newIndicator.getOptions(), Set.of());
        Set oldAnalysisGroups = oldIndicator.getGroups().stream().map(NamedConfigurableObjectBase::getName).collect(Collectors.toSet());
        List<AnalysisGroup> addedAnalysisGroups = newIndicator.getGroups().stream().filter(analysisGroup -> !oldAnalysisGroups.contains(analysisGroup.getName())).toList();
        Set<String> addedAnalysisGroupsNames = addedAnalysisGroups.stream().map(NamedConfigurableObjectBase::getName).collect(Collectors.toSet());
        Set newAnalysisGroups = newIndicator.getGroups().stream().map(NamedConfigurableObjectBase::getName).collect(Collectors.toSet());
        List<AnalysisGroup> removedAnalysisGroups = oldIndicator.getGroups().stream().filter(analysisGroup -> !newAnalysisGroups.contains(analysisGroup.getName())).toList();
        Map<String, AnalysisGroup> oldAnalysisGroupsMap = oldIndicator.getGroups().stream().collect(Collectors.toMap(NamedConfigurableObjectBase::getName, group -> group));
        List<AnalysisGroupDifference> analysisGroupDifferences = AnalysisProfileEditVersionComparison.getAnalysisGroupDifferences(oldAnalysisGroupsMap, newIndicator, addedAnalysisGroupsNames);
        String oldName = null;
        if (!oldIndicator.getName().equals(newIndicator.getName())) {
            oldName = oldIndicator.getName();
        }
        if (oldName == null && addedAnalysisGroups.isEmpty() && removedAnalysisGroups.isEmpty() && analysisGroupDifferences.isEmpty() && optionDiff.isEmpty()) {
            return;
        }
        qualityIndicatorDifferences.add(new QualityIndicatorDifference(newIndicator.getName(), oldName, addedAnalysisGroups, removedAnalysisGroups, analysisGroupDifferences, optionDiff));
    }

    private static List<AnalysisGroupDifference> getAnalysisGroupDifferences(Map<String, AnalysisGroup> allOldAnalysisGroups, QualityIndicator newIndicator, Set<String> addedAnalysisGroupsNames) {
        ArrayList<AnalysisGroupDifference> analysisGroupDifferences = new ArrayList<AnalysisGroupDifference>();
        for (AnalysisGroup newAnalysisGroup : newIndicator.getGroups()) {
            AnalysisGroup oldAnalysisGroup;
            if (addedAnalysisGroupsNames.contains(newAnalysisGroup.getName()) || (oldAnalysisGroup = allOldAnalysisGroups.get(newAnalysisGroup.getName())) == null) continue;
            UnmodifiableSet<String> newChecks = newAnalysisGroup.getOptionNames();
            UnmodifiableSet<String> oldChecks = oldAnalysisGroup.getOptionNames();
            Set<String> addedChecks = newChecks.stream().filter(check -> !oldChecks.contains(check) && newAnalysisGroup.getOptionValue((String)check) != null && !newAnalysisGroup.getOptionValue((String)check).isEmpty()).collect(Collectors.toSet());
            Set<String> removedChecks = oldChecks.stream().filter(check -> !newChecks.contains(check) && oldAnalysisGroup.getOptionValue((String)check) != null && !oldAnalysisGroup.getOptionValue((String)check).isEmpty()).collect(Collectors.toSet());
            List<String[]> difference = AnalysisProfileEditVersionComparisonUtils.getDifferenceInOptions(allOldAnalysisGroups.get(newAnalysisGroup.getName()).getOptions(), newAnalysisGroup.getOptions(), addedChecks);
            if (addedChecks.isEmpty() && removedChecks.isEmpty() && difference.isEmpty()) continue;
            analysisGroupDifferences.add(AnalysisProfileEditVersionComparison.createNewAnalysisGroupDifference(newAnalysisGroup.getName(), addedChecks, removedChecks, difference, newAnalysisGroup.getOptions(), oldAnalysisGroup.getOptions()));
        }
        return analysisGroupDifferences;
    }

    /*
     * Exception decompiling
     */
    private static AnalysisGroupDifference createNewAnalysisGroupDifference(String analysisGroupName, Set<String> addedChecks, Set<String> removedChecks, List<String[]> difference, Map<String, String> newAnalysisGroupOptions, Map<String, String> oldAnalysisGroupOptions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Optional<QualityIndicator> getMatchingOldQualityIndicator(QualityIndicator newIndicator, List<QualityIndicator> oldQualityIndicators, Map<String, String> nameMatching) {
        return oldQualityIndicators.stream().filter(qualityIndicator -> qualityIndicator.getName().equals(newIndicator.getName()) || qualityIndicator.getName().equals(nameMatching.get(newIndicator.getName()))).findFirst();
    }
}

