/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectBranchingConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompiler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.Contract;

public final class ProjectConfigurationUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void checkProjectNameAndIds(IndexLayer indexLayer, ProjectConfiguration projectConfiguration) throws ProjectConfigurationException, StorageException {
        UnmodifiableList<PublicProjectId> publicIds = projectConfiguration.getPublicIds();
        if (CollectionUtils.isNullOrEmpty(publicIds)) {
            throw new ProjectConfigurationException("Missing project IDs!");
        }
        for (PublicProjectId publicId : publicIds) {
            if ("__global__".equals(publicId.toString())) {
                throw new ProjectConfigurationException("__global__ is a reserved identifier and cannot be used as project ID.");
            }
            if (PublicProjectId.isValidId((PublicProjectId)publicId)) continue;
            throw new ProjectConfigurationException("Invalid project ID \"" + String.valueOf(publicId) + "\"! May only contain alphanumeric characters, underscore, hyphen and dot.");
        }
        if (StringUtils.isEmpty((String)projectConfiguration.getName())) {
            throw new ProjectConfigurationException("Missing project name!");
        }
        ProjectConfigurationUtils.checkDuplicateId(indexLayer, projectConfiguration);
    }

    public static boolean parentProjectCanBeResolved(IndexLayer indexLayer, ProjectConfiguration projectConfiguration, boolean validateProject) throws StorageException, ProjectConfigurationException {
        ProjectIndex projectIndex;
        Optional<ProjectInfo> projectInfo;
        IProjectId parentProjectId = projectConfiguration.getParentProjectId();
        if (parentProjectId != null && (projectInfo = (projectIndex = indexLayer.openGlobalIndex(ProjectIndex.class)).tryResolveProject(parentProjectId)).isEmpty()) {
            if (validateProject) {
                throw new ProjectConfigurationException("Parent project " + String.valueOf(parentProjectId) + " not found!");
            }
            LOGGER.error("Could not find parent project {}.", (Object)parentProjectId);
            return false;
        }
        return true;
    }

    private static void checkDuplicateId(IndexLayer indexLayer, ProjectConfiguration projectConfiguration) throws StorageException, ProjectConfigurationException {
        ProjectIndex projectIndex = indexLayer.openProjectIndex();
        if (projectIndex.getProjectWithoutPublicIdResolution(projectConfiguration.getInternalId()).isPresent()) {
            throw new ProjectConfigurationException("Project " + projectConfiguration.getName() + " (ID: " + String.valueOf(projectConfiguration.getInternalId()) + ") already exists!");
        }
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            HashSet publicIdIntersectionSet = CollectionUtils.intersectionSet(projectConfiguration.getPublicIds(), (Collection[])new Collection[]{projectInfo.getPublicIds()});
            if (publicIdIntersectionSet.isEmpty()) continue;
            throw new ProjectConfigurationException("One or more projects of the same name(s) %s already exist. You need to rename or remove said projects, before adding this one.".formatted(publicIdIntersectionSet));
        }
    }

    public static AnalysisProfile determineAnalysisProfile(IndexLayer indexLayer, ProjectConfiguration projectConfiguration, CodeScopeName codeScopeName) throws ProjectConfigurationException, StorageException {
        AnalysisProfileIndex profileIndex;
        AnalysisProfile embeddedProfile = projectConfiguration.getEmbeddedProfile(codeScopeName);
        String profileName = projectConfiguration.getAnalysisProfileName(codeScopeName);
        if (!StringUtils.isEmpty((String)profileName) && embeddedProfile != null) {
            throw new ProjectConfigurationException("Project configuration has both embedded profile and referenced profile!");
        }
        if (StringUtils.isEmpty((String)profileName) && embeddedProfile == null) {
            throw new ProjectConfigurationException("Analysis profile not provided!");
        }
        AnalysisProfile profile = embeddedProfile;
        if (profile == null && (profile = (profileIndex = indexLayer.openGlobalIndex(AnalysisProfileIndex.class)).getProfile(profileName)) == null) {
            throw new ProjectConfigurationException("No analysis profile found with name " + profileName + "!");
        }
        return profile;
    }

    public static String getAnalysisProfileNameForProject(IProjectId projectId, IndexLayer indexLayer, CodeScopeName codeScopeName) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration(projectId, indexLayer);
        return projectConfiguration.getAnalysisProfileName(codeScopeName);
    }

    public static @Nullable ProjectConfiguration getProjectConfiguration(ProjectInfo project, IndexLayer indexLayer) throws StorageException {
        return ProjectConfigurationUtils.getProjectConfiguration(indexLayer.openProjectStorageSystem(project));
    }

    public static @Nullable ProjectConfiguration getProjectConfiguration(IProjectId projectId, IndexLayer indexLayer) throws StorageException {
        return ProjectConfigurationUtils.getProjectConfiguration(indexLayer.openProjectStorageSystem(projectId));
    }

    public static @Nullable ProjectConfiguration getProjectConfiguration(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return ProjectConfigurationUtils.getProjectConfiguration(projectStorageSystem, false);
    }

    public static @Nullable ProjectConfiguration getProjectConfigurationWithoutEmbeddedProfile(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return ProjectConfigurationUtils.getProjectConfiguration(projectStorageSystem, true);
    }

    private static @Nullable ProjectConfiguration getProjectConfiguration(ProjectStorageSystem projectStorageSystem, boolean removeEmbeddedProfile) throws StorageException {
        MetaIndex projectMetaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        return ProjectConfigurationUtils.getProjectConfiguration(projectMetaIndex, removeEmbeddedProfile);
    }

    @Contract(value="null->fail")
    public static @Nullable ProjectConfiguration getProjectConfiguration(@Nullable MetaIndex projectMetaIndex) throws StorageException {
        if (projectMetaIndex == null) {
            throw new StorageException("Project meta index not found. Failed to retrieve project configuration.");
        }
        return ProjectConfigurationUtils.getProjectConfiguration(projectMetaIndex, false);
    }

    public static @Nullable ProjectConfiguration getProjectConfiguration(MetaIndex projectMetaIndex, boolean removeEmbeddedProfile) throws StorageException {
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        if (removeEmbeddedProfile) {
            projectConfiguration.getCodeScopeNames().forEach(codeScope -> projectConfiguration.setEmbeddedProfile(null, (CodeScopeName)codeScope));
        }
        return projectConfiguration;
    }

    public static List<ProjectConfiguration> getProjectConfigurations(List<PublicProjectId> projects, IndexLayer indexLayer) throws StorageException {
        ArrayList<ProjectConfiguration> projectConfigurations = new ArrayList<ProjectConfiguration>();
        for (PublicProjectId project : projects) {
            projectConfigurations.add(ProjectConfigurationUtils.getProjectConfiguration((IProjectId)project, indexLayer));
        }
        return projectConfigurations;
    }

    public static @Nullable List<AnalysisTrigger> loadPreviousTriggers(GlobalStorageSystem globalStorageSystem, ProjectStorageSystem projectStorageSystem) throws StorageException {
        TriggerIndex triggerIndex = (TriggerIndex)projectStorageSystem.openProjectIndex(TriggerIndex.class, null);
        try {
            return new TriggerCompiler(projectStorageSystem.getSchema(), globalStorageSystem.getSchema()).compile(triggerIndex.getAllTriggers());
        }
        catch (TriggerCompilationException e) {
            LOGGER.error("Could not re-compile previous triggers, continuing without them", (Throwable)e);
            return null;
        }
    }

    public static ProjectBranchingConfiguration loadPreviousBranchingConfiguration(ProjectStorageSystem projectStorageSystem) throws StorageException {
        MetaIndex projectMetaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        return (ProjectBranchingConfiguration)projectMetaIndex.getValue(ProjectBranchingConfiguration.class);
    }

    public static List<ConnectorConfiguration> getRequirementConnectors(ProjectConfiguration projectConfiguration) {
        return projectConfiguration.getConnectorsByNames((Set<String>)ERequirementsManagementTool.getReadableNames());
    }

    private ProjectConfigurationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

