/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.option;

import com.teamscale.core.analysis.configuration.model.option.IConfigOptionDescriptorBehaviour;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import java.util.Collections;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ExternalToolCheckOptionDescriptor
implements IConfigOptionDescriptorBehaviour {
    private final EToolCheckOptionType type;
    private final Map<String, Object> valueByOptionsId;
    private final String fullQualifiedID;

    public ExternalToolCheckOptionDescriptor(Map<String, Object> valueByOptionsId, String fullQualifiedID, EToolCheckOptionType type) {
        this.valueByOptionsId = valueByOptionsId;
        this.fullQualifiedID = fullQualifiedID;
        this.type = type;
    }

    @Override
    public Object retrieveValue(CodeScopeName codeScopeName) {
        return this.valueByOptionsId.get(this.fullQualifiedID);
    }

    @Override
    public Object retrieveDefaultValue() {
        return this.retrieveValue(null);
    }

    public @NonNull UnmodifiableList<Object> retrieveValues() {
        return CollectionUtils.asUnmodifiable(Collections.singletonList(this.retrieveValue(null)));
    }

    @Override
    public void storeValue(Object value, CodeScopeName codeScopeName) {
        this.valueByOptionsId.put(this.fullQualifiedID, value);
    }

    @Override
    public String getTypeName() {
        return this.type.getTypeName();
    }
}

