/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate;

import com.teamscale.commons.annotation.ClassIndexUtils;
import com.teamscale.core.authenticate.IUserAuthenticator;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class AuthenticationManager {
    public static final String LOGIN_PAGE_URL = "login";
    private static final Logger LOGGER = LogManager.getLogger();
    private static AuthenticationManager instance;
    private final Set<Class<? extends IUserAuthenticator>> authenticatorClasses = new HashSet<Class<? extends IUserAuthenticator>>();
    private final HashMap<String, IUserAuthenticator> authenticators = new HashMap();

    private AuthenticationManager() {
        ClassIndexUtils.getConcreteSubclasses(IUserAuthenticator.class).forEach(this::registerAuthenticator);
    }

    public static synchronized AuthenticationManager getInstance() {
        if (instance == null) {
            instance = new AuthenticationManager();
        }
        return instance;
    }

    public static synchronized void destroyInstance() {
        instance = null;
    }

    public synchronized Set<String> getAuthenticatorNames(ServerOptionIndex index) throws StorageException {
        this.setupAuthenticators();
        HashSet<String> authNames = new HashSet<String>();
        for (IUserAuthenticator authenticator : this.authenticators.values()) {
            authNames.addAll(authenticator.getAllNames(index));
        }
        return authNames;
    }

    public static String getAuthenticatorName(String authentication) {
        String[] authenticatorParts = authentication.split(":", 2);
        return authenticatorParts[0];
    }

    public synchronized IUserAuthenticator getAuthenticator(String name) {
        this.setupAuthenticators();
        if (this.authenticators.containsKey(name)) {
            return this.authenticators.get(name);
        }
        return null;
    }

    private void registerAuthenticator(Class<? extends IUserAuthenticator> authenticatorClass) {
        CCSMAssert.isFalse((boolean)this.isInitialized(), (String)"This method may not be called after using it for authentication.");
        this.authenticatorClasses.add(authenticatorClass);
    }

    public synchronized boolean isInitialized() {
        return !this.authenticators.isEmpty();
    }

    public synchronized User authenticate(String username, byte[] password, UserIndex userIndex, ServerOptionIndex optionIndex, boolean shouldLogFailedLogin) throws StorageException {
        this.setupAuthenticators();
        User user = userIndex.getUser(username);
        if (user == null) {
            if (shouldLogFailedLogin) {
                LOGGER.warn("Login failed for user '{}'. No user registered with this name.", (Object)StringEscapeUtils.escapeJava((String)username));
            }
            return null;
        }
        if (this.authenticate(username, password, optionIndex, user, shouldLogFailedLogin)) {
            return user;
        }
        return null;
    }

    private boolean authenticate(String username, byte[] password, ServerOptionIndex optionIndex, User user, boolean shouldLogFailedLogin) throws StorageException {
        String authenticatorString = user.getAuthenticator();
        String[] authenticatorParts = authenticatorString.split(":", 2);
        IUserAuthenticator authenticator = this.getAuthenticator(authenticatorParts[0]);
        if (authenticator == null) {
            if (shouldLogFailedLogin) {
                LOGGER.warn("Login failed for user '{}'. Malformed authenticator string in escaped format: '{}'.", (Object)StringEscapeUtils.escapeJava((String)username), (Object)StringEscapeUtils.escapeJava((String)user.getAuthenticator()));
            }
            return false;
        }
        String authentication = authenticatorParts[0];
        if (authenticatorParts.length == 2) {
            authentication = authenticatorParts[1];
        }
        if (!authenticator.authenticate(user, password, authentication, optionIndex)) {
            if (shouldLogFailedLogin) {
                LOGGER.warn("Login failed for user '{}'. Authenticator rejected password.", (Object)StringEscapeUtils.escapeJava((String)username));
            }
            return false;
        }
        return true;
    }

    private synchronized void setupAuthenticators() {
        if (this.isInitialized()) {
            return;
        }
        for (Class<? extends IUserAuthenticator> authenticatorClass : this.authenticatorClasses) {
            try {
                IUserAuthenticator authenticator = authenticatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.authenticators.put(authenticator.getAuthenticatorIdentifier(), authenticator);
            }
            catch (ReflectiveOperationException e) {
                LOGGER.error("Could not implement authenticator from class " + String.valueOf(authenticatorClass), (Throwable)e);
            }
        }
    }

    public boolean authenticatorAllowsLogin(String authenticatorName) {
        IUserAuthenticator authenticator = this.getAuthenticator(authenticatorName);
        return authenticator != null && authenticator.allowsLogin();
    }

    public @Nullable String sanitizeAuthenticator(String authenticatorString) {
        if (authenticatorString == null) {
            return null;
        }
        String[] authenticatorParts = authenticatorString.split(":", 2);
        IUserAuthenticator authenticator = this.getAuthenticator(authenticatorParts[0]);
        if (authenticator == null || authenticatorParts.length < 2) {
            return authenticatorParts[0];
        }
        return authenticatorParts[0] + ":" + authenticator.sanitizeAuthenticator(authenticatorParts[1]);
    }

    public static boolean isDenyAll(User user) {
        return user != null && "DenyAll".equals(AuthenticationManager.getAuthenticatorName(user.getAuthenticator()));
    }
}

