/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate;

import com.teamscale.core.authenticate.SessionDuration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Index(name="sessions", options={EStorageOption.ENCRYPTED}, valueClasses={Pair.class, Long.class})
public class SessionIndex
implements IGlobalIndex {
    private static final String LOCK_SUFFIX = "update";
    private final ValueIndex<Pair<Long, Long>> delegate;

    public SessionIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public List<String> removeTokensForUsers(Collection<String> usernames) throws StorageException {
        return (List)this.delegate.computeLocked(LOCK_SUFFIX, () -> {
            List<String> userTokenPrefixes = usernames.stream().map(username -> username + ":").toList();
            UnmodifiableList tokensToDelete = this.delegate.getEntriesStartingWith(userTokenPrefixes).getFirstList();
            this.delegate.removeValues((Collection)tokensToDelete);
            return tokensToDelete;
        });
    }

    public Optional<SessionDuration> getSessionDuration(String sessionToken) throws StorageException {
        return (Optional)this.delegate.computeLocked(LOCK_SUFFIX, () -> Optional.ofNullable((Pair)this.delegate.getValue(sessionToken)).map(SessionIndex::fromIndexValue));
    }

    public void storeSessionDuration(String sessionToken, SessionDuration sessionDuration) throws StorageException {
        this.delegate.runLocked(LOCK_SUFFIX, () -> this.delegate.setValue(sessionToken, SessionIndex.asIndexValue(sessionDuration)));
    }

    public SessionDuration extendTimeout(String sessionToken) throws StorageException {
        return (SessionDuration)this.delegate.computeLocked(LOCK_SUFFIX, () -> {
            SessionDuration extendedTimeout = SessionIndex.fromIndexValue((Pair<Long, Long>)((Pair)this.delegate.getValue(sessionToken, true))).getExtendedDuration();
            this.delegate.setValue(sessionToken, SessionIndex.asIndexValue(extendedTimeout));
            return extendedTimeout;
        });
    }

    public void removeSession(String sessionToken) throws StorageException {
        this.delegate.runLocked(LOCK_SUFFIX, () -> this.delegate.removeValue(sessionToken));
    }

    public void removeSessions(List<String> tokensToDelete) throws StorageException {
        if (tokensToDelete.isEmpty()) {
            return;
        }
        this.delegate.runLocked(LOCK_SUFFIX, () -> this.delegate.removeValues((Collection)tokensToDelete));
    }

    public PairList<String, SessionDuration> getAllSessions() throws StorageException {
        return (PairList)this.delegate.computeLocked(LOCK_SUFFIX, () -> this.delegate.getAllEntries().mapSecond(SessionIndex::fromIndexValue));
    }

    public void cleanupSessionsTimedOutBefore(Instant instant) throws StorageException {
        this.delegate.runLocked(LOCK_SUFFIX, () -> {
            PairList allSessions = this.delegate.getAllEntries().mapSecond(SessionIndex::fromIndexValue);
            List sessionsToDelete = allSessions.filter((token, duration) -> duration.isTimedOutBefore(instant)).extractFirstList();
            this.delegate.removeValues((Collection)sessionsToDelete);
        });
    }

    public void removeAllSessions() throws StorageException {
        this.delegate.runLocked(LOCK_SUFFIX, () -> this.delegate.removeAllEntries());
    }

    private static Pair<Long, Long> asIndexValue(SessionDuration sessionDuration) {
        return Pair.createPair((Object)sessionDuration.timeout().toEpochMilli(), (Object)sessionDuration.endOfLife().toEpochMilli());
    }

    private static SessionDuration fromIndexValue(Pair<Long, Long> indexValue) {
        return new SessionDuration(Instant.ofEpochMilli((Long)indexValue.getFirst()), Instant.ofEpochMilli((Long)indexValue.getSecond()));
    }
}

