/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.ldap;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.ServerDescriptionBase;
import com.teamscale.core.authenticate.ldap.LDAPAuthenticator;
import com.teamscale.core.authenticate.ldap.LDAPServerDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserUtils;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RoundRobinDNSServerSet;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;

public final class LDAPUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String LDAP_DN_PART_SPLITTER = ",";
    private static final String LDAP_DN_KEY_VALUE_SEPARATOR = "=";
    static final String LDAP_USER_FULL_DN_FIELD = "ldap.user.uid.field";
    private static final int MAX_CONNECTIONS_PER_POOL = 10;
    private static final Map<String, LDAPConnectionPool> LDAP_CONNECTION_POOLS = new HashMap<String, LDAPConnectionPool>();
    private static final Duration LDAP_DNS_CACHE_TIMEOUT = DurationUtils.ONE_HOUR;
    private static SSLSocketFactory sslSocketFactory = null;
    private static ObjectClassConfig objectClassConfig = ObjectClassConfig.DEFAULT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LDAPConnectionPool getConnectionPool(LDAPServerDescription server) throws LDAPException {
        LDAPConnectionPool connectionPool;
        String poolKey = server.getConnectionPoolKey();
        Map<String, LDAPConnectionPool> map = LDAP_CONNECTION_POOLS;
        synchronized (map) {
            connectionPool = LDAP_CONNECTION_POOLS.get(poolKey);
            if (connectionPool == null) {
                connectionPool = LDAPUtils.createNewConnectionPool(server);
                LDAP_CONNECTION_POOLS.put(poolKey, connectionPool);
            }
        }
        return connectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnectionPool(LDAPServerDescription server) {
        Map<String, LDAPConnectionPool> map = LDAP_CONNECTION_POOLS;
        synchronized (map) {
            LDAPConnectionPool pool = LDAP_CONNECTION_POOLS.remove(server.getConnectionPoolKey());
            if (pool != null) {
                pool.close();
            }
        }
    }

    public static LDAPConnection createSingleConnection(LDAPServerDescription server) throws LDAPException {
        return LDAPUtils.createServerSet(server).getConnection();
    }

    private static LDAPConnectionPool createNewConnectionPool(LDAPServerDescription server) throws LDAPException {
        ServerSet serverSet = LDAPUtils.createServerSet(server);
        return new LDAPConnectionPool(serverSet, (BindRequest)new SimpleBindRequest(server.bindDN, server.bindPassword), 10);
    }

    private static ServerSet createServerSet(LDAPServerDescription server) throws LDAPException {
        LDAPConnectionOptions options = LDAPUtils.createLDAPConnectionOptions();
        SSLSocketFactory factory = LDAPUtils.getSSLSocketFactory(server);
        return new RoundRobinDNSServerSet(server.hostname, server.port, RoundRobinDNSServerSet.AddressSelectionMode.FAILOVER, LDAP_DNS_CACHE_TIMEOUT.toMillis(), null, (SocketFactory)factory, options);
    }

    private static LDAPConnectionOptions createLDAPConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setFollowReferrals(true);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLSocketFactory getSSLSocketFactory(LDAPServerDescription server) throws LDAPException {
        if (!server.useSSL) {
            return null;
        }
        Class<LDAPUtils> clazz = LDAPUtils.class;
        synchronized (LDAPUtils.class) {
            if (sslSocketFactory == null) {
                SSLUtil sslUtil = new SSLUtil((TrustManager)new TrustAllTrustManager());
                try {
                    sslSocketFactory = sslUtil.createSSLSocketFactory();
                }
                catch (GeneralSecurityException e) {
                    throw new LDAPException(ResultCode.OTHER, (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sslSocketFactory;
        }
    }

    public static Optional<User> findUser(String uidOrDN, LDAPServerDescription server, String ldapServerName, ServerOptionIndex optionIndex) throws LDAPException, StorageException {
        Entry entry = LDAPUtils.findUserEntry(uidOrDN, server);
        if (entry != null && LDAPUtils.isForeignSecurityPrincipal(entry)) {
            ForeignSecurityPrincipal foreignSecurityPrincipal = LDAPUtils.resolveForeignSecurityPrincipal(entry, server, optionIndex);
            if (foreignSecurityPrincipal == null) {
                return Optional.empty();
            }
            return Optional.of(LDAPUtils.createUserFromForeignSecurityPrincipal(foreignSecurityPrincipal));
        }
        if (entry == null || !LDAPUtils.isUserEntry(entry)) {
            return Optional.empty();
        }
        if (LDAPUtils.isDeactivatedUser(entry)) {
            LOGGER.warn("Failed to resolve user. Account disabled: {}", (Object)uidOrDN);
            return Optional.empty();
        }
        return Optional.of(LDAPUtils.createUserFromEntry(server, ldapServerName, entry));
    }

    private static Entry findUserEntry(String uidOrDN, LDAPServerDescription server) throws LDAPException {
        SearchResult entries;
        Optional<SearchResultEntry> entry;
        if (DN.isValidDN((String)uidOrDN)) {
            return LDAPUtils.getConnectionPool(server).getEntry(uidOrDN);
        }
        if (!StringUtils.isEmpty((String)server.emailAttribute) && uidOrDN.contains("@") && (entry = (entries = LDAPUtils.searchEntries(server, Filter.createEqualityFilter((String)server.emailAttribute, (String)uidOrDN))).getSearchEntries().stream().filter(Predicate.not(LDAPUtils::isDeactivatedUser)).findFirst()).isPresent()) {
            return (Entry)entry.get();
        }
        return LDAPUtils.searchEntry(server, Filter.createEqualityFilter((String)server.loginAttribute, (String)uidOrDN));
    }

    private static User createUserFromForeignSecurityPrincipal(ForeignSecurityPrincipal foreignSecurityPrincipal) throws LDAPException {
        return LDAPUtils.createUserFromEntry(foreignSecurityPrincipal.getServer().serverDescription(), foreignSecurityPrincipal.getServer().name(), foreignSecurityPrincipal.getEntry());
    }

    private static Entry searchEntry(LDAPServerDescription server, Filter query) throws LDAPException {
        SearchResult searchResult = LDAPUtils.searchEntries(server, query);
        if (searchResult.getEntryCount() != 0) {
            return (Entry)searchResult.getSearchEntries().getFirst();
        }
        LOGGER.warn("Empty result for query '{}' executed on server '{}': {}", (Object)query, (Object)server, (Object)searchResult);
        return null;
    }

    private static SearchResult searchEntries(LDAPServerDescription server, Filter query) throws LDAPException {
        return LDAPUtils.getConnectionPool(server).search(server.baseDN, SearchScope.SUB, query, new String[0]);
    }

    private static ForeignSecurityPrincipal resolveForeignSecurityPrincipal(Entry entry, LDAPServerDescription server, ServerOptionIndex optionIndex) throws LDAPException, StorageException {
        String userSid = LDAPUtils.decodeSID(entry.getAttributeValueByteArrays("objectSID")[0]);
        String userRid = StringUtils.removeLastPart((String)userSid, (char)'-');
        for (Entry entry2 : LDAPUtils.getTrustedDomains(entry, server)) {
            String domainSid = LDAPUtils.decodeSID(entry2.getAttributeValueByteArrays("securityIdentifier")[0]);
            if (!userRid.equals(domainSid)) continue;
            String hostname = entry2.getAttributeValue("trustPartner");
            for (String configuredServerName : AuthenticationToolUtils.getServerNames(EAuthenticationTool.LDAP, optionIndex)) {
                NamedServer<LDAPServerDescription> configuredServer = ServerDescriptionBase.getServer(optionIndex, EAuthenticationTool.LDAP, LDAPServerDescription.class, configuredServerName);
                CCSMAssert.isNotNull(configuredServer, (String)("Configured server not found: " + configuredServerName));
                LDAPServerDescription serverDescription = configuredServer.serverDescription();
                if (!serverDescription.hostname.equals(hostname)) continue;
                return LDAPUtils.resolveForeignSecurityPrincipal(userSid, configuredServer);
            }
        }
        LOGGER.error("Unable to resolve foreign security principal: {}", (Object)entry);
        return null;
    }

    private static ForeignSecurityPrincipal resolveForeignSecurityPrincipal(String userSid, NamedServer<LDAPServerDescription> configuredServer) throws LDAPException {
        LDAPUtils.removeConnectionPool(configuredServer.serverDescription());
        Entry entry = LDAPUtils.searchEntry(configuredServer.serverDescription(), Filter.createEqualityFilter((String)"objectSid", (String)userSid));
        if (entry == null) {
            LOGGER.error("Search for foreign security principal with SID {} on server '{}' returned no results", (Object)userSid, (Object)configuredServer.name());
            return null;
        }
        return new ForeignSecurityPrincipal(entry, configuredServer);
    }

    private static List<SearchResultEntry> getTrustedDomains(Entry entry, LDAPServerDescription server) throws LDAPException {
        Object baseDN = "cn=System";
        String dcPart = LDAPUtils.getPartFromDN(entry.getDN(), "dc");
        if (!StringUtils.isEmpty((String)dcPart)) {
            baseDN = (String)baseDN + LDAP_DN_PART_SPLITTER + dcPart;
        }
        return LDAPUtils.getConnectionPool(server).search((String)baseDN, SearchScope.SUB, Filter.createEqualityFilter((String)"objectClass", (String)"trustedDomain"), new String[0]).getSearchEntries();
    }

    private static String getPartFromDN(String dn, String searchPart) {
        ArrayList<String> dcParts = new ArrayList<String>();
        String[] parts = dn.split(LDAP_DN_PART_SPLITTER);
        String partStart = searchPart + LDAP_DN_KEY_VALUE_SEPARATOR;
        for (String part : parts) {
            if (!part.toLowerCase().startsWith(partStart)) continue;
            dcParts.add(part);
        }
        return StringUtils.concat(dcParts, (String)LDAP_DN_PART_SPLITTER);
    }

    private static boolean isForeignSecurityPrincipal(Entry entry) {
        return LDAPUtils.getObjectClassValues(entry).contains((Object)"foreignSecurityPrincipal");
    }

    public static String decodeSID(byte[] sid) {
        int sidIndex = 0;
        StringBuilder result = new StringBuilder("S-");
        result.append(Integer.toString(sid[sidIndex++]));
        int countSubAuths = sid[sidIndex++] & 0xFF;
        long authority = 0L;
        while (sidIndex <= 7) {
            authority |= (long)sid[sidIndex] << 8 * (7 - sidIndex);
            ++sidIndex;
        }
        result.append("-").append(Long.toHexString(authority));
        int subAuthoritySize = 4;
        for (int j = 0; j < countSubAuths; ++j) {
            long subAuthority = 0L;
            for (int k = 0; k < subAuthoritySize; ++k) {
                subAuthority |= (long)(sid[sidIndex++] & 0xFF) << 8 * k;
            }
            result.append("-").append(subAuthority);
        }
        return result.toString();
    }

    private static String getLoginAttributeFromDN(LDAPServerDescription server, Entry entry) throws LDAPException {
        String uidIncludingPrefixFromDN;
        String uidFromDN;
        List<String> uids = Arrays.asList(entry.getAttributeValues(server.loginAttribute));
        if (!uids.contains(uidFromDN = StringUtils.getLastPart((String)(uidIncludingPrefixFromDN = LDAPUtils.getPartFromDN(entry.getDN(), server.loginAttribute)), (String)LDAP_DN_KEY_VALUE_SEPARATOR))) {
            throw new LDAPException(ResultCode.OTHER, "Inconsistent value for " + server.loginAttribute + " in DN.");
        }
        if (StringUtils.isEmpty((String)uidFromDN)) {
            return entry.getAttributeValue(server.loginAttribute);
        }
        return uidFromDN;
    }

    private static User createUserFromEntry(LDAPServerDescription server, String ldapServerName, Entry entry) throws LDAPException {
        String username = EFeatureToggle.ENABLE_APPLE_SPECIFIC_FEATURES.isEnabled() ? LDAPUtils.getLoginAttributeFromDN(server, entry) : entry.getAttributeValue(server.loginAttribute);
        if (StringUtils.isEmpty((String)username)) {
            throw new LDAPException(ResultCode.OTHER, "Obtained empty login using attribute " + server.loginAttribute);
        }
        String firstName = StringUtils.emptyIfNull((String)entry.getAttributeValue(server.firstNameAttribute));
        String lastName = StringUtils.emptyIfNull((String)entry.getAttributeValue(server.lastNameAttribute));
        String email = StringUtils.emptyIfNull((String)entry.getAttributeValue(server.emailAttribute));
        String authenticator = AuthenticationToolUtils.buildAuthenticator(LDAPAuthenticator.IDENTIFIER, ldapServerName);
        User user = new User(username, firstName, lastName, email, authenticator);
        user.setAdditionalField(LDAP_USER_FULL_DN_FIELD, entry.getDN());
        return user;
    }

    public static Optional<User> updateOrImportUser(String uid, LDAPServerDescription server, String ldapServerName, UserIndex userIndex, ServerOptionIndex optionIndex, IMessageBroker messageBroker) throws StorageException, AuthenticationToolException {
        Optional<User> user;
        try {
            user = LDAPUtils.findUser(uid, server, ldapServerName, optionIndex);
        }
        catch (LDAPException e) {
            throw new AuthenticationToolException("Importing/Updating user failed", e);
        }
        if (user.isPresent()) {
            UserUtils.updateUserInIndex(userIndex, user.get(), LDAP_USER_FULL_DN_FIELD, messageBroker);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((User)user.get()).toString();
            supplierArray[1] = server::getUrl;
            LOGGER.info("Updated/Imported user '{}' from LDAP server '{}'", supplierArray);
        } else {
            LOGGER.warn("User not found or account disabled: {}", (Object)uid);
        }
        return user;
    }

    public static ListMap<NamedServer<LDAPServerDescription>, String> getUsersInGroup(String serverName, LDAPServerDescription server, UserGroup userGroup, ServerOptionIndex optionIndex) throws LDAPException, StorageException, AuthenticationToolException {
        return LDAPUtils.getUsersInGroup(serverName, server, userGroup.getRemoteGroup(), optionIndex, new HashSet<String>());
    }

    private static ListMap<NamedServer<LDAPServerDescription>, String> getUsersInGroup(String serverName, LDAPServerDescription server, String ldapGroupNameOrDN, ServerOptionIndex optionIndex, Set<String> alreadyImportedGroups) throws LDAPException, StorageException, AuthenticationToolException {
        ListMap<NamedServer<LDAPServerDescription>, String> users = LDAPUtils.getUsersInGroup(serverName, server, ldapGroupNameOrDN, optionIndex, alreadyImportedGroups, server.memberUid);
        if (!users.isEmpty()) {
            return users;
        }
        boolean tryNextPage = true;
        int page = 0;
        while (tryNextPage) {
            String memberUidWithRange = LDAPUtils.getMemberRange(server.memberUid, page, false);
            ListMap<NamedServer<LDAPServerDescription>, String> usersForPage = LDAPUtils.getUsersInGroup(serverName, server, ldapGroupNameOrDN, optionIndex, alreadyImportedGroups, memberUidWithRange);
            if (usersForPage.isEmpty()) {
                memberUidWithRange = LDAPUtils.getMemberRange(server.memberUid, page, true);
                usersForPage = LDAPUtils.getUsersInGroup(serverName, server, ldapGroupNameOrDN, optionIndex, alreadyImportedGroups, memberUidWithRange);
                tryNextPage = false;
            }
            users.addAll(usersForPage);
            ++page;
        }
        return users;
    }

    private static ListMap<NamedServer<LDAPServerDescription>, String> getUsersInGroup(String serverName, LDAPServerDescription server, String ldapGroupNameOrDN, ServerOptionIndex optionIndex, Set<String> alreadyImportedGroups, String memberUidWithRange) throws LDAPException, StorageException, AuthenticationToolException {
        Attribute attribute;
        ForeignSecurityPrincipal foreignSecurityPrincipal;
        ListMap users = new ListMap();
        SearchResultEntry groupEntry = LDAPUtils.searchForGroupEntry(ldapGroupNameOrDN, server, memberUidWithRange);
        if (LDAPUtils.isForeignSecurityPrincipal((Entry)groupEntry) && (foreignSecurityPrincipal = LDAPUtils.resolveForeignSecurityPrincipal((Entry)groupEntry, server, optionIndex)) != null) {
            groupEntry = foreignSecurityPrincipal.getEntry();
            server = foreignSecurityPrincipal.getServerDescription();
            serverName = foreignSecurityPrincipal.getServerName();
        }
        if ((attribute = groupEntry.getAttribute(memberUidWithRange)) == null || attribute.getValues().length == 0) {
            LOGGER.debug("Could not find attribute: {}", (Object)memberUidWithRange);
        }
        if (attribute != null) {
            LDAPUtils.importMembersInGroup(attribute, serverName, server, ldapGroupNameOrDN, (ListMap<NamedServer<LDAPServerDescription>, String>)users, optionIndex, alreadyImportedGroups);
        }
        LOGGER.debug("Found {} users for attribute: {}", (Object)users.size(), (Object)memberUidWithRange);
        return users;
    }

    @VisibleForTesting
    public static String getMemberRange(String memberUid, int page, boolean openUpperBound) {
        int lowerBound = page * 1500;
        if (openUpperBound) {
            return String.format("%s;range=%d-*", memberUid, lowerBound);
        }
        int upperBound = (page + 1) * 1500 - 1;
        return String.format("%s;range=%d-%d", memberUid, lowerBound, upperBound);
    }

    private static void importMembersInGroup(Attribute attribute, String serverName, LDAPServerDescription server, String ldapGroupNameOrDN, ListMap<NamedServer<LDAPServerDescription>, String> users, ServerOptionIndex optionIndex, Set<String> alreadyImportedGroups) {
        for (String member : attribute.getValues()) {
            if (alreadyImportedGroups.contains(member)) continue;
            try {
                if (LDAPUtils.isNestedGroup(member, server, optionIndex)) {
                    alreadyImportedGroups.add(member);
                    users.addAll(LDAPUtils.getUsersInGroup(serverName, server, member, optionIndex, alreadyImportedGroups));
                    continue;
                }
                users.add(new NamedServer<LDAPServerDescription>(serverName, server), (Object)member);
            }
            catch (AuthenticationToolException | LDAPException | StorageException e) {
                LOGGER.error("Could not resolve group member '{}' in LDAP group '{}'. Skipping member.", (Object)member, (Object)ldapGroupNameOrDN);
            }
        }
    }

    private static boolean isNestedGroup(String groupOrUsername, LDAPServerDescription server, ServerOptionIndex optionIndex) throws LDAPException, StorageException {
        if (!DN.isValidDN((String)groupOrUsername)) {
            return false;
        }
        SearchResultEntry entry = LDAPUtils.getConnectionPool(server).getEntry(groupOrUsername);
        return (entry = LDAPUtils.resolveForeignSecurityPrincipalToEntry((Entry)entry, server, optionIndex)) != null && LDAPUtils.isGroupEntry((Entry)entry);
    }

    public static boolean groupExists(String groupName, LDAPServerDescription server, ServerOptionIndex optionIndex) throws LDAPException, StorageException {
        SearchResultEntry entry;
        if (DN.isValidDN((String)groupName)) {
            entry = LDAPUtils.getConnectionPool(server).getEntry(groupName);
        } else {
            SearchResult searchResult = LDAPUtils.searchForGroup(groupName, server);
            if (searchResult.getSearchEntries().isEmpty()) {
                return false;
            }
            entry = (Entry)searchResult.getSearchEntries().getFirst();
        }
        entry = LDAPUtils.resolveForeignSecurityPrincipalToEntry((Entry)entry, server, optionIndex);
        return entry != null && LDAPUtils.isGroupEntry((Entry)entry);
    }

    private static @Nullable Entry resolveForeignSecurityPrincipalToEntry(Entry entry, LDAPServerDescription server, ServerOptionIndex optionIndex) throws LDAPException, StorageException {
        ForeignSecurityPrincipal foreignSecurityPrincipal;
        if (entry != null && LDAPUtils.isForeignSecurityPrincipal(entry) && (foreignSecurityPrincipal = LDAPUtils.resolveForeignSecurityPrincipal(entry, server, optionIndex)) != null) {
            return foreignSecurityPrincipal.getEntry();
        }
        return entry;
    }

    private static SearchResult searchForGroup(String groupName, LDAPServerDescription server) throws LDAPException {
        Filter filter = Filter.createEqualityFilter((String)server.groupAttribute, (String)groupName);
        return LDAPUtils.getConnectionPool(server).search(server.groupsBaseDN, SearchScope.SUB, filter, new String[0]);
    }

    private static boolean isGroupEntry(Entry entry) {
        CaseInsensitiveStringSet attributeValues = LDAPUtils.getObjectClassValues(entry);
        return LDAPUtils.objectClassConfig.groupObjectClasses.stream().anyMatch(arg_0 -> ((CaseInsensitiveStringSet)attributeValues).contains(arg_0));
    }

    private static boolean isUserEntry(Entry entry) {
        CaseInsensitiveStringSet attributeValues = LDAPUtils.getObjectClassValues(entry);
        return LDAPUtils.objectClassConfig.userObjectClasses.stream().anyMatch(arg_0 -> ((CaseInsensitiveStringSet)attributeValues).contains(arg_0));
    }

    private static boolean isDeactivatedUser(Entry entry) {
        Attribute userAccountControlAttribute = entry.getAttribute("UserAccountControl");
        if (!LDAPUtils.getObjectClassValues(entry).contains((Object)"user") || userAccountControlAttribute == null) {
            return false;
        }
        Integer userAccountControlValue = userAccountControlAttribute.getValueAsInteger();
        return (userAccountControlValue & 2) > 0;
    }

    private static CaseInsensitiveStringSet getObjectClassValues(Entry entry) {
        return new CaseInsensitiveStringSet(Arrays.asList(entry.getObjectClassValues()));
    }

    public static UserGroup findGroup(String groupName, LDAPServerDescription server, String serverName) throws AuthenticationToolException {
        try {
            SearchResultEntry resultEntry = LDAPUtils.searchForGroupEntry(groupName, server, null);
            if (!LDAPUtils.isGroupEntry((Entry)resultEntry)) {
                throw new AuthenticationEntityNotFoundException(groupName + " is no valid group.");
            }
            return new UserGroup(resultEntry.getAttribute(server.groupAttribute).getValue(), EAuthenticationTool.LDAP, resultEntry.getDN(), serverName);
        }
        catch (LDAPException e) {
            throw new AuthenticationToolException("Fetching group failed", e);
        }
    }

    public static List<UserGroup> searchForAllGroupEntries(String serverName, LDAPServerDescription serverDescription) {
        Filter filter = Filter.createPresenceFilter((String)serverDescription.groupAttribute);
        try {
            SearchResult searchResult = LDAPUtils.getConnectionPool(serverDescription).search(serverDescription.groupsBaseDN, SearchScope.SUB, filter, new String[0]);
            return CollectionUtils.map((Collection)searchResult.getSearchEntries(), resultEntry -> new UserGroup(resultEntry.getAttribute(serverDescription.groupAttribute).getValue(), EAuthenticationTool.LDAP, resultEntry.getDN(), serverName));
        }
        catch (LDAPException e) {
            LOGGER.error("Could not retrieve LDAP groups from '{}': {}", (Object)serverDescription.hostname, (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    private static SearchResultEntry searchForGroupEntry(String groupNameOrDN, LDAPServerDescription serverDescription, String rangeAttribute) throws LDAPException, AuthenticationToolException {
        SearchResultEntry entry;
        if (DN.isValidDN((String)groupNameOrDN)) {
            if (rangeAttribute == null) {
                entry = LDAPUtils.getConnectionPool(serverDescription).getEntry(groupNameOrDN);
            } else {
                LOGGER.debug("LDAP search result entry for range attribute {}", (Object)rangeAttribute);
                entry = LDAPUtils.getConnectionPool(serverDescription).getEntry(groupNameOrDN, new String[]{rangeAttribute, "objectClass", "cn", "objectSID", "uSNChanged", "name", "objectGUID", "sAMAccountName", "sAMAccountType"});
                LOGGER.debug((Object)entry);
            }
            if (entry == null) {
                throw new AuthenticationEntityNotFoundException("LDAP group " + groupNameOrDN + " was not found.");
            }
        } else {
            SearchResult searchResult = LDAPUtils.searchForGroup(groupNameOrDN, serverDescription);
            if (searchResult.getSearchEntries().isEmpty()) {
                throw new AuthenticationEntityNotFoundException("LDAP group " + groupNameOrDN + " was not found.");
            }
            entry = (SearchResultEntry)searchResult.getSearchEntries().getFirst();
        }
        return entry;
    }

    private static List<String> listAllWithFilterAndLimit(LDAPServerDescription server, String baseDN, String attribute, Filter filter, int limit) throws LDAPException {
        SearchRequest request = new SearchRequest(baseDN, SearchScope.SUB, filter, new String[0]);
        request.setSizeLimit(limit);
        try {
            SearchResult searchResult = LDAPUtils.getConnectionPool(server).search(request);
            return CollectionUtils.map((Collection)searchResult.getSearchEntries(), entry -> entry.getAttributeValue(attribute));
        }
        catch (LDAPSearchException e) {
            if (LDAPUtils.isRecoverableSearchException(e)) {
                return CollectionUtils.map((Collection)e.getSearchEntries(), entry -> entry.getAttributeValue(attribute));
            }
            throw e;
        }
    }

    private static boolean isRecoverableSearchException(LDAPSearchException e) {
        ResultCode resultCode = e.getResultCode();
        return ResultCode.SIZE_LIMIT_EXCEEDED.equals((Object)resultCode) || ResultCode.ADMIN_LIMIT_EXCEEDED.equals((Object)resultCode);
    }

    public static String getUserDN(LDAPServerDescription server, User user, String serverName, ServerOptionIndex optionIndex) throws LDAPException, StorageException {
        String dn = user.getAdditionalField(LDAP_USER_FULL_DN_FIELD);
        if (dn == null) {
            Optional<User> newUser = LDAPUtils.findUser(user.getUsername(), server, serverName, optionIndex);
            return newUser.map(value -> value.getAdditionalField(LDAP_USER_FULL_DN_FIELD)).orElse(null);
        }
        return dn;
    }

    private static List<String> listAttributeWithPrefix(LDAPServerDescription server, String baseDN, String attribute, String prefix, int limit, String errorMessage) throws AuthenticationToolException {
        Filter filter = Filter.createSubstringFilter((String)attribute, (String)prefix, null, null);
        try {
            return LDAPUtils.listAllWithFilterAndLimit(server, baseDN, attribute, filter, limit);
        }
        catch (LDAPException e) {
            throw new AuthenticationToolException(errorMessage, e);
        }
    }

    public static List<String> listUserNamesWithPrefix(LDAPServerDescription server, String prefix, int limit) throws AuthenticationToolException {
        return LDAPUtils.listAttributeWithPrefix(server, server.baseDN, server.loginAttribute, prefix, limit, "Failed fetching user suggestions!");
    }

    public static List<String> listGroupNamesWithPrefix(LDAPServerDescription server, String prefix, int limit) throws AuthenticationToolException {
        return LDAPUtils.listAttributeWithPrefix(server, server.groupsBaseDN, server.groupAttribute, prefix, limit, "Failed fetching group suggestions!");
    }

    private LDAPUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    private static class ForeignSecurityPrincipal {
        private final Entry entry;
        private final NamedServer<LDAPServerDescription> server;

        private ForeignSecurityPrincipal(Entry entry, NamedServer<LDAPServerDescription> server) {
            this.entry = entry;
            this.server = server;
        }

        public String getServerName() {
            return this.server.name();
        }

        private LDAPServerDescription getServerDescription() {
            return this.server.serverDescription();
        }

        public Entry getEntry() {
            return this.entry;
        }

        public NamedServer<LDAPServerDescription> getServer() {
            return this.server;
        }
    }

    @VisibleForTesting
    static class ObjectClassConfig {
        private static final ObjectClassConfig DEFAULT = new ObjectClassConfig(System.getProperties());
        private final Set<String> userObjectClasses;
        private final Set<String> groupObjectClasses;

        private ObjectClassConfig(Properties jvmProperties) {
            this.userObjectClasses = ObjectClassConfig.readObjectClassesFromJvmFlag("com.teamscale.authenticate.ldap.user-object-classes", jvmProperties, "user", "inetorgperson");
            this.groupObjectClasses = ObjectClassConfig.readObjectClassesFromJvmFlag("com.teamscale.authenticate.ldap.group-object-classes", jvmProperties, "group", "groupOfNames", "posixgroup");
        }

        private static Set<String> readObjectClassesFromJvmFlag(String propertyName, Properties jvmProperties, String ... defaultValues) {
            HashSet<String> objectClasses = new HashSet<String>(Set.of(defaultValues));
            String propertyValue = jvmProperties.getProperty(propertyName);
            if (!StringUtils.isEmpty((String)propertyValue)) {
                Arrays.stream(propertyValue.split(LDAPUtils.LDAP_DN_PART_SPLITTER)).map(String::trim).forEach(objectClasses::add);
            }
            return objectClasses;
        }

        @VisibleForTesting
        static void withTemporaryConfig(Properties properties, RunnableWithException<Exception> runnable) throws Exception {
            try {
                objectClassConfig = new ObjectClassConfig(properties);
                runnable.run();
            }
            finally {
                objectClassConfig = DEFAULT;
            }
        }
    }
}

