/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class FindingTypeDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME_PROPERTY = "name";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String TOOL_PROPERTY = "tool";
    private static final String PROPERTY_DESCRIPTIONS_PROPERTY = "propertyDescriptions";
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="tool")
    private final EAnalysisTool tool;
    @JsonProperty(value="propertyDescriptions")
    private final Map<String, String> propertyDescriptions = new HashMap<String, String>();

    @JsonCreator
    public FindingTypeDescription(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="tool") EAnalysisTool tool) {
        this.name = name;
        this.description = description;
        this.tool = tool;
    }

    public FindingTypeDescription(FindingDescriptor findingDescriptor) {
        this(findingDescriptor.getReadableName(), findingDescriptor.getDescription(), findingDescriptor.getTool());
        this.propertyDescriptions.putAll((Map<String, String>)findingDescriptor.getPropertyDescriptions());
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public EAnalysisTool getTool() {
        return this.tool;
    }

    public void setPropertyDescription(String propertyName, String description) {
        this.propertyDescriptions.put(propertyName, description);
    }

    public String getPropertyDescription(String propertyName) {
        return this.propertyDescriptions.get(propertyName);
    }

    public Map<String, String> getPropertyDescriptions() {
        return this.propertyDescriptions;
    }
}

