/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.index;

import com.teamscale.core.index.CommitResolver;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import java.io.File;
import java.util.Optional;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.cache.StorageCacheConfiguration;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.IndexSchemaCache;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStorageSystemProviderDecorator;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.ParentedStorageSystem;
import org.conqat.engine.persistence.store.SchemaNotFoundException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.readcache.ReadCachingStorageSystem;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class IndexLayer {
    public static final String GLOBAL_PARTITION = "__global__";
    private final IStorageSystemProvider rawStorageSystemProvider;
    private final File storageDirectory;
    private final StorageCacheProvider storageCacheProvider;
    private final IMessageBroker messageBroker;
    private GlobalStorageSystem globalStorageSystem;

    public IndexLayer(IStorageSystemProvider rawStorageSystemProvider, StorageCacheProvider storageCacheProvider, IMessageBroker messageBroker) {
        this(rawStorageSystemProvider, storageCacheProvider, messageBroker, null);
    }

    public IndexLayer(IStorageSystemProvider rawStorageSystemProvider, StorageCacheProvider storageCacheProvider, IMessageBroker messageBroker, File storageDirectory) {
        this.rawStorageSystemProvider = rawStorageSystemProvider;
        this.storageCacheProvider = storageCacheProvider;
        this.messageBroker = messageBroker;
        this.storageDirectory = storageDirectory;
    }

    public <T extends IProjectIndex> T openNonHistorizedProjectIndex(Class<T> indexClass, IProjectId projectId) throws StorageException {
        return (T)this.openNonCommitResolvingProjectStorageSystem(projectId).openProjectIndex(indexClass, null);
    }

    public <T extends IProjectIndex> T openNonHistorizedProjectIndex(Class<T> indexClass, ProjectInfo project) throws StorageException {
        return (T)this.openNonCommitResolvingProjectStorageSystem(project.getInternalId()).openProjectIndex(indexClass, null);
    }

    public MetaIndex openMetaIndex(IProjectId projectId) throws StorageException {
        return this.openNonHistorizedProjectIndex(MetaIndex.class, projectId);
    }

    public MetaIndex openMetaIndex() throws StorageException {
        return this.openGlobalIndex(MetaIndex.class);
    }

    public synchronized GlobalStorageSystem openGlobalStorageSystem() throws StorageException {
        if (this.globalStorageSystem == null) {
            this.globalStorageSystem = new GlobalStorageSystem(this.openStorageSystem(GLOBAL_PARTITION), this.getStorageSystemCacheProvider(GLOBAL_PARTITION));
        }
        return this.globalStorageSystem;
    }

    public ProjectStorageSystem openNonCommitResolvingProjectStorageSystem(IProjectId projectId) throws StorageException {
        return this.openNonCommitResolvingProjectStorageSystem(this.resolveToInternalProjectId(projectId));
    }

    public ProjectStorageSystem openNonCommitResolvingProjectStorageSystem(InternalProjectId projectId) throws StorageException {
        CCSMAssert.isNotNull((Object)projectId);
        try {
            return new ProjectStorageSystem(this.openStorageSystem(projectId.toString()), this.getStorageSystemCacheProvider(projectId.toString()));
        }
        catch (SchemaNotFoundException e) {
            throw new SchemaNotFoundException("Storage schema not found for project '" + String.valueOf(projectId) + "'.Probably, the name of the project was misspelled or the project does not exist.", (Throwable)e);
        }
        catch (StorageException e) {
            throw new StorageException("Error creating storage system for project '" + String.valueOf(projectId) + "'", (Throwable)e);
        }
    }

    private IStorageSystem openStorageSystem(String storageSystemName) throws StorageException {
        SynchronizedCacheAccess schemaCache;
        IStorageSystem storageSystem = this.rawStorageSystemProvider.openStorageSystem(storageSystemName);
        IndexSchema indexSchema = IndexSchema.load((IStorageSystem)storageSystem, (SynchronizedCacheAccess)(schemaCache = this.getStorageSystemCacheProvider(storageSystemName).getCacheAccess(IndexSchemaCache.class)));
        Optional parentStorageSystemName = indexSchema.getParentStorageSystemName();
        if (parentStorageSystemName.isEmpty()) {
            return storageSystem;
        }
        return new ParentedStorageSystem(storageSystem, this.rawStorageSystemProvider.openStorageSystem((String)parentStorageSystemName.get()), indexSchema);
    }

    public IStorageSystem openRawProjectStorageSystem(InternalProjectId internalProjectId) throws StorageException {
        return this.rawStorageSystemProvider.openStorageSystem(internalProjectId.toString());
    }

    public IStorageSystem openRawGlobalStorageSystem() throws StorageException {
        return this.rawStorageSystemProvider.openStorageSystem(GLOBAL_PARTITION);
    }

    public StorageCacheProvider.StorageSystemCacheProvider getStorageSystemCacheProvider(String storageSystemName) {
        return this.storageCacheProvider.getCacheProvider(storageSystemName);
    }

    public ProjectIndex openProjectIndex() throws StorageException {
        return this.openGlobalIndex(ProjectIndex.class);
    }

    public ProjectInfo resolveProject(IProjectId projectId) throws StorageException {
        CCSMAssert.isNotNull((Object)projectId);
        return this.openProjectIndex().resolveProject(projectId);
    }

    public InternalProjectId resolveToInternalProjectId(IProjectId projectId) throws StorageException {
        CCSMAssert.isNotNull((Object)projectId);
        return this.openProjectIndex().resolveToInternalId(projectId);
    }

    public PublicProjectId resolveToPrimaryPublicProjectId(IProjectId projectId) throws StorageException {
        CCSMAssert.isNotNull((Object)projectId);
        ProjectInfo projectInfo = this.openProjectIndex().resolveProject(projectId);
        return projectInfo.getPrimaryPublicId();
    }

    public <T extends IGlobalIndex> T openGlobalIndex(Class<T> clazz) throws StorageException {
        return (T)this.openGlobalStorageSystem().openGlobalIndex(clazz);
    }

    public BranchAnalysisStateIndex openBranchAnalysisStateIndex(InternalProjectId projectId) throws StorageException {
        if (SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            return new BranchAnalysisStateIndex((IStore)new InMemoryStore());
        }
        return this.openNonHistorizedProjectIndex(BranchAnalysisStateIndex.class, (IProjectId)projectId);
    }

    public StorageCacheProvider getStorageCacheProvider() {
        return this.storageCacheProvider;
    }

    public IStorageSystemProvider getRawStorageSystemProvider() {
        return this.rawStorageSystemProvider;
    }

    public CommitResolvingStorageSystem openProjectStorageSystem(IProjectId projectId, StorageCacheConfiguration cacheConfiguration) throws StorageException {
        CCSMAssert.isNotNull((Object)projectId);
        ProjectStorageSystem projectStorageSystem = this.openNonCommitResolvingProjectStorageSystem(projectId);
        if (cacheConfiguration.maximumStoreCacheSize() > 0L) {
            projectStorageSystem = new ReadCachingStorageSystem((IStorageSystem)projectStorageSystem, cacheConfiguration.maximumStoreCacheSize());
        }
        return new CommitResolvingStorageSystem((IStorageSystem)projectStorageSystem, this.getStorageSystemCacheProvider(this.resolveToInternalProjectId(projectId).toString()), new CommitResolver(), cacheConfiguration);
    }

    public CommitResolvingStorageSystem openProjectStorageSystem(ProjectInfo project) throws StorageException {
        return this.openProjectStorageSystem((IProjectId)project.getInternalId(), StorageCacheConfiguration.NO_CACHING);
    }

    public CommitResolvingStorageSystem openProjectStorageSystem(IProjectId projectId) throws StorageException {
        return this.openProjectStorageSystem(projectId, StorageCacheConfiguration.NO_CACHING);
    }

    public <T extends IProjectIndex> T openProjectIndex(ProjectInfo project, Class<T> indexClass, HistoryAccessOption historyAccessOption) throws StorageException {
        return this.openProjectStorageSystem(project).openProjectIndex(indexClass, historyAccessOption);
    }

    public <T extends IProjectIndexWithDynamicName> T openProjectIndex(IProjectId projectId, Class<T> indexClass, String indexName, HistoryAccessOption historyAccessOption) throws StorageException {
        InternalProjectId resolvedProjectId = this.resolveToInternalProjectId(projectId);
        if (resolvedProjectId == null) {
            throw new StorageException("Project with ID " + String.valueOf(projectId) + " cannot be resolved.");
        }
        return this.openProjectStorageSystem((IProjectId)resolvedProjectId).openProjectIndex(indexClass, indexName, historyAccessOption);
    }

    public <T extends IProjectIndex> T openProjectIndex(IProjectId projectId, Class<T> indexClass, HistoryAccessOption historyAccessOption) throws StorageException {
        InternalProjectId resolvedProjectId = this.resolveToInternalProjectId(projectId);
        if (resolvedProjectId == null) {
            throw new StorageException("Project with ID " + String.valueOf(projectId) + " cannot be resolved.");
        }
        return this.openProjectStorageSystem((IProjectId)resolvedProjectId).openProjectIndex(indexClass, historyAccessOption);
    }

    public IMessageBroker getMessageBroker() {
        return this.messageBroker;
    }

    public void saveGlobalIndexSchema(IndexSchema indexSchema) throws StorageException {
        SynchronizedCacheAccess schemaCache = this.getStorageSystemCacheProvider(GLOBAL_PARTITION).getCacheAccess(IndexSchemaCache.class);
        indexSchema.save(this.rawStorageSystemProvider.openStorageSystem(GLOBAL_PARTITION), schemaCache);
    }

    public void saveProjectIndexSchema(IProjectId projectId, IndexSchema indexSchema) throws StorageException {
        InternalProjectId internalProjectId = this.resolveToInternalProjectId(projectId);
        SynchronizedCacheAccess schemaCache = this.getStorageSystemCacheProvider(internalProjectId.toString()).getCacheAccess(IndexSchemaCache.class);
        indexSchema.save(this.openRawProjectStorageSystem(internalProjectId), schemaCache);
    }

    public IndexLayer decorate(IStorageSystemProviderDecorator decorator) {
        return new IndexLayer(decorator.decorate(this.rawStorageSystemProvider), this.storageCacheProvider, this.messageBroker);
    }

    public Optional<File> getStorageDirectory() {
        return Optional.ofNullable(this.storageDirectory);
    }
}

