/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.license;

import com.teamscale.core.license.License;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class LicenseUtil {
    private static final String SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    private static final String SIGNATURE_ALGORITHM = "SHA1withDSA";
    private static final String KEY_FACTORY_ALGORITHM = "DSA";

    public static Signature createSignature() throws NoSuchAlgorithmException {
        return Signature.getInstance(SIGNATURE_ALGORITHM);
    }

    public static KeyFactory createKeyFactory() throws NoSuchAlgorithmException {
        return KeyFactory.getInstance(KEY_FACTORY_ALGORITHM);
    }

    public static SecureRandom getSecureRandomAlgorithm() throws NoSuchAlgorithmException {
        return SecureRandom.getInstance(SECURE_RANDOM_ALGORITHM);
    }

    public static KeyPairGenerator getKeyPairAlgorithm() throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(KEY_FACTORY_ALGORITHM);
    }

    public static void writeLicenseToFile(License license, File licenseFile) throws IOException {
        try (FileWriter writer = new FileWriter(licenseFile, StandardCharsets.UTF_8);){
            license.write(writer);
        }
    }

    private LicenseUtil() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

