/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.IDynamicMetricComputation;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.values.EMetricValueType;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class MetricDirectorySchemaEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME_PROPERTY = "name";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String AGGREGATION_PROPERTY = "aggregation";
    private static final String PROPERTIES_PROPERTY = "properties";
    private static final String VALUE_TYPE_PROPERTY = "valueType";
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="aggregation")
    private final EAggregation aggregation;
    @JsonProperty(value="properties")
    private final EnumSet<EMetricProperty> properties;
    @JsonProperty(value="valueType")
    private final EMetricValueType valueType;
    @JsonIgnore
    private final @Nullable IDynamicMetricComputation dynamicMetricComputation;

    @JsonCreator
    public MetricDirectorySchemaEntry(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="aggregation") EAggregation aggregation, @JsonProperty(value="valueType") EMetricValueType valueType, @JsonProperty(value="properties") Set<EMetricProperty> properties) {
        this(name, description, aggregation, valueType, properties, null);
    }

    public MetricDirectorySchemaEntry(String name, String description, EAggregation aggregation, EMetricValueType valueType, Set<EMetricProperty> properties, @Nullable IDynamicMetricComputation dynamicMetricComputation) {
        this.name = name;
        this.description = description;
        this.aggregation = aggregation;
        this.valueType = valueType;
        this.properties = EnumUtils.safeCopyOf(properties, EMetricProperty.class);
        this.dynamicMetricComputation = dynamicMetricComputation;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EAggregation getAggregation() {
        if (this.aggregation == null) {
            return EAggregation.NONE;
        }
        return this.aggregation;
    }

    public boolean isHidden() {
        return this.hasProperty(EMetricProperty.HIDDEN);
    }

    public EMetricValueType getValueType() {
        return this.valueType;
    }

    public boolean hasProperty(EMetricProperty property) {
        return this.properties.contains((Object)property);
    }

    public Set<EMetricProperty> getProperties() {
        return EnumSet.copyOf(this.properties);
    }

    public Optional<IDynamicMetricComputation> getDynamicMetricComputation() {
        return Optional.ofNullable(this.dynamicMetricComputation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.aggregation, this.valueType, this.properties});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetricDirectorySchemaEntry)) {
            return false;
        }
        MetricDirectorySchemaEntry other = (MetricDirectorySchemaEntry)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && this.aggregation == other.aggregation && this.valueType == other.valueType && Objects.equals(this.properties, other.properties);
    }

    public String toString() {
        return this.name + ":" + String.valueOf((Object)this.valueType);
    }

    @ExportToTypeScript
    @IndexValueClass(containedInBackup=true)
    public static enum EAggregation {
        SUM,
        MIN,
        MAX,
        UNION,
        NONE;

    }
}

