/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.migrators.ReportSlideMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedIntField;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion113AddCodeFontSizeParameter
extends ReportSlideMigratorBase {
    private static final String TASK_DETAIL_SLIDE_CLASS = "com.teamscale.index.quality_report.slides.TaskDetailSlide";
    private static final String TASK_DETAIL_PARAMETER_CLASS = "com.teamscale.index.quality_report.slides.TaskDetailSlide$TaskDetailSlideParameters";
    private static final String FINDING_DETAIL_SLIDE_CLASS = "com.teamscale.index.quality_report.slides.FindingDetailSlide";
    private static final String FINDING_DETAIL_PARAMETER_CLASS = "com.teamscale.index.quality_report.slides.FindingDetailSlide$FindingDetailSlideParameters";
    private static final String CODE_FONT_SIZE_PARAMETER_NAME = "codeFontSize";

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        this.updateCodeFontSizeForSlideType(entityPool, TASK_DETAIL_SLIDE_CLASS, TASK_DETAIL_PARAMETER_CLASS, 5);
        this.updateCodeFontSizeForSlideType(entityPool, FINDING_DETAIL_SLIDE_CLASS, FINDING_DETAIL_PARAMETER_CLASS, 9);
    }

    private void updateCodeFontSizeForSlideType(SerializedEntityPool entityPool, String slideClass, String slideParameterClass, int varCount) throws IOException {
        for (SerializedObject detailSlide : SerializedEntityUtils.findInstancesOf((SerializedClass)entityPool.findClass(slideClass), (SerializedEntityPool)entityPool)) {
            SerializedClass serializedClass = entityPool.findClass(slideParameterClass);
            if (serializedClass != null && !serializedClass.containsField(CODE_FONT_SIZE_PARAMETER_NAME)) {
                serializedClass.addField((SerializedFieldBase)new SerializedIntField(CODE_FONT_SIZE_PARAMETER_NAME));
            }
            SerializedObject slideParameters = (SerializedObject)entityPool.getEntity(((Integer)detailSlide.getFieldValue("slideParameters")).intValue(), SerializedObject.class);
            slideParameters.setFieldValue(CODE_FONT_SIZE_PARAMETER_NAME, (Object)15);
            SerializedObject slideParameterDescriptorsObject = (SerializedObject)entityPool.getEntity(((Integer)slideParameters.getFieldValue("parameterDescriptors")).intValue(), SerializedObject.class);
            SerializedClass listClass = SerializationMigrationUtils.findClassInHierarchy((SerializedObject)slideParameterDescriptorsObject, ArrayList.class);
            SerializedClassValues fieldSets = slideParameterDescriptorsObject.getFieldSet(slideParameterDescriptorsObject.getPlainClassHierarchy().indexOf(listClass));
            SerializedObject newParameterDescriptor = MigrateVersion113AddCodeFontSizeParameter.createParameterDescriptorObject(entityPool, CODE_FONT_SIZE_PARAMETER_NAME, "Code font size", "SIZE", "");
            fieldSets.getPostFieldData().add(4, newParameterDescriptor.getHandle());
            fieldSets.setValue(0, (Object)varCount);
            SerializedObject updatedParameterDescriptors = new SerializedObject(slideParameterDescriptorsObject.getClassHandle(), Collections.singletonList(fieldSets), entityPool);
            slideParameters.setFieldValue("parameterDescriptors", (Object)updatedParameterDescriptors.getHandle());
        }
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V113;
    }
}

