/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.migrators.ReportSlideMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.io.IOException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedObjectField;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion142AddTitleParameterMarkdownSlide
extends ReportSlideMigratorBase {
    private static final String MARKDOWN_SLIDE_CLASS = "com.teamscale.index.quality_report.slides.MarkdownSlide";
    private static final String MARKDOWN_PARAMETER_CLASS = "com.teamscale.index.quality_report.slides.MarkdownSlide$MarkdownSlideParameters";
    private static final String SLIDE_TITLE = "slideTitle";

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        this.addTitleOptionForSlideType(entityPool, MARKDOWN_SLIDE_CLASS, MARKDOWN_PARAMETER_CLASS);
    }

    private void addTitleOptionForSlideType(SerializedEntityPool entityPool, String slideClass, String slideParameterClass) throws IOException {
        SerializedClass serializedParameterClass = entityPool.findClass(slideParameterClass);
        if (serializedParameterClass != null && !serializedParameterClass.containsField(SLIDE_TITLE)) {
            serializedParameterClass.addField((SerializedFieldBase)new SerializedObjectField(SLIDE_TITLE, SerializedObjectField.STRING_TYPE));
        }
        for (SerializedObject slide : SerializedEntityUtils.findInstancesOf((SerializedClass)entityPool.findClass(slideClass), (SerializedEntityPool)entityPool)) {
            SerializedObject slideParameters = (SerializedObject)entityPool.getEntity(((Integer)slide.getFieldValue("slideParameters")).intValue(), SerializedObject.class);
            slideParameters.setFieldValue(SLIDE_TITLE, (Object)new SerializedStringObject("", entityPool).getHandle());
        }
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V143;
    }
}

