/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.migrators.DashboardMigratorBase;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.serialization.utils.SerializedClassFieldMigrator;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public abstract class MigrateVersion179ThresholdConfigurationProjectOption
extends SerializedValueMigratorBase {
    protected MigrateVersion179ThresholdConfigurationProjectOption(boolean compressed) {
        super(compressed);
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V179;
    }

    @ThreadSafe
    public static class MigrateNumberOfDaysInFutureMetricsTableWidget
    extends DashboardMigratorBase {
        private static final String NUMBER_OF_DAYS_IN_FUTURE_FIELD_NAME = "Number of days in future";

        @Override
        public String migrateDescriptorJSON(String descriptorJSON) throws MigrationException {
            return new DashboardMigratorBase.SafeJsonWidgetMigrator(MigrateNumberOfDaysInFutureMetricsTableWidget::migrateNumberOfDaysInFutureParameter).migrate(descriptorJSON);
        }

        private static ObjectNode migrateNumberOfDaysInFutureParameter(ObjectNode widget) {
            widget.remove(NUMBER_OF_DAYS_IN_FUTURE_FIELD_NAME);
            return widget;
        }

        @Override
        public EStorageSystemVersion getVersion() {
            return EStorageSystemVersion.STORAGE_SYSTEM_V179;
        }
    }

    @ThreadSafe
    public static class MigrateSlideRenderDataIndex
    extends MigrateVersion179ThresholdConfigurationProjectOption {
        protected MigrateSlideRenderDataIndex() {
            super(true);
        }

        @Override
        public EStorageMigratorType getType() {
            return EStorageMigratorType.GLOBAL;
        }

        @Override
        public String getStoreName() {
            return "slide-render-data";
        }

        @Override
        protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
            new SerializedClassFieldMigrator(entityPool).removeField("com.teamscale.core.analysis.configuration.index.model.EvaluatedMetricThreshold", "evaluationDate");
        }
    }

    @ThreadSafe
    public static class MigrateProjectOptionIndex
    extends MigrateVersion179ThresholdConfigurationProjectOption {
        private static final String OLD_NAME = "com.teamscale.index.thresholds.ProjectThresholdConfigurationsOption";
        private static final String NEW_NAME = "com.teamscale.index.thresholds.ProjectThresholdConfigurationOption";
        private static final String OLD_KEY = "<p>:threshold.configurations";
        private static final String NEW_KEY = "<p>:threshold.configuration";
        private static final String OLD_FIELD_NAME = "thresholdConfigurationsWithTimeSpecification";
        private static final String NEW_FIELD_NAME = "thresholdConfigurationName";

        protected MigrateProjectOptionIndex() {
            super(true);
        }

        @Override
        public EStorageMigratorType getType() {
            return EStorageMigratorType.PROJECT;
        }

        @Override
        public String getStoreName() {
            return "project-options";
        }

        @Override
        protected byte[] migrateKey(byte[] key) {
            if (StringUtils.bytesToString((byte[])key).equals(OLD_KEY)) {
                return StringUtils.stringToBytes((String)NEW_KEY);
            }
            return super.migrateKey(key);
        }

        @Override
        protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
            SerializedClass optionClass = entityPool.findClass(OLD_NAME);
            if (optionClass == null) {
                return;
            }
            optionClass.setName(NEW_NAME);
            new SerializedClassFieldMigrator(entityPool).addStringField(NEW_NAME, NEW_FIELD_NAME, "Teamscale Default");
            for (SerializedObject serializedObject : SerializedEntityUtils.findInstancesOf((SerializedClass)optionClass, (SerializedEntityPool)entityPool)) {
                int listHandle = (Integer)serializedObject.getFieldValue(OLD_FIELD_NAME);
                SerializedObject oldValue = (SerializedObject)entityPool.getEntity(listHandle, SerializedObject.class);
                List arrayList = SerializationMigrationUtils.getObjectsFromArrayList((SerializedObject)oldValue, (SerializedEntityPool)entityPool);
                if (arrayList.isEmpty()) continue;
                SerializedObject defaultConfig = (SerializedObject)arrayList.getFirst();
                Object thresholdConfigurationName = defaultConfig.getFieldValue(NEW_FIELD_NAME);
                serializedObject.setFieldValue(NEW_FIELD_NAME, thresholdConfigurationName);
            }
            new SerializedClassFieldMigrator(entityPool).removeField(NEW_NAME, OLD_FIELD_NAME);
            entityPool.removeEntitiesOfType("com.teamscale.index.thresholds.MetricThresholdConfigurationWithTimeSpecification");
            entityPool.removeEntitiesOfType("java.util.ArrayList");
            entityPool.removeEntitiesOfType("java.util.Date");
        }
    }
}

