/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.progress;

import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgress;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public abstract class BranchAnalysisStateBase<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Long> completionBoundaryByStore = new HashMap<String, Long>();

    public abstract SortedMap<Long, T> getWrittenStoresByTimestamp();

    public abstract boolean updateWrittenStores(long var1, Set<String> var3, ScheduledJob var4);

    public abstract Optional<ProjectAnalysisProgress.ConflictInfo> getConflictInfo(CommitDescriptor var1, Set<String> var2, boolean var3, @Nullable UUID var4, long var5);

    public boolean discardFutureProgress(long limitTimestamp) {
        AtomicBoolean changed = new AtomicBoolean(this.getWrittenStoresByTimestamp().keySet().removeIf(timestamp -> timestamp > limitTimestamp));
        this.completionBoundaryByStore.replaceAll((store, timestamp) -> {
            if (timestamp <= limitTimestamp) {
                return timestamp;
            }
            changed.setPlain(true);
            return limitTimestamp;
        });
        return changed.getPlain();
    }

    protected  @Nullable ProjectAnalysisProgress.ConflictInfo getConflictWithCompletionBoundaryByStore(CommitDescriptor schedulingCommit, Set<String> transitiveWriteStores, @Nullable UUID rollbackId, long maximumAllowedCompletionBoundary) {
        for (String store : CollectionUtils.sort(transitiveWriteStores)) {
            if (maximumAllowedCompletionBoundary >= this.completionBoundaryByStore.getOrDefault(store, 0L)) continue;
            return new ProjectAnalysisProgress.ConflictInfo(new CommitDescriptor(schedulingCommit.getBranchName(), maximumAllowedCompletionBoundary), "Timestamp " + maximumAllowedCompletionBoundary + " is less or equal to completion boundary timestamp of the write store '" + store + "':" + String.valueOf(this.completionBoundaryByStore.get(store)), rollbackId);
        }
        return null;
    }

    public boolean discardUnusedTimestampsAndMarkStoresWritten(Set<Long> usedTimestamps, JobDescriptor job, ITrigger trigger, String branchName) {
        if (this.getWrittenStoresByTimestamp().isEmpty()) {
            return false;
        }
        boolean changed = false;
        if (job.getSchedulingCommit() != null && job.getSchedulingCommit().getBranchName().equals(branchName)) {
            for (String store : trigger.getWriteStores()) {
                Long oldValue = this.completionBoundaryByStore.put(store, job.getSchedulingCommit().getTimestamp());
                changed |= oldValue == null || oldValue.longValue() != job.getSchedulingCommit().getTimestamp();
            }
        }
        Long maxTimestamp = this.getWrittenStoresByTimestamp().lastKey();
        usedTimestamps.add(maxTimestamp);
        return changed |= this.getWrittenStoresByTimestamp().keySet().retainAll(usedTimestamps);
    }

    public String toString() {
        return this.getWrittenStoresByTimestamp().toString();
    }
}

