/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.progress;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.performance.PerformanceIndexBase;
import com.teamscale.core.runtime.api.performance.PerformanceMetricsIndex;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.api.progress.IProjectAnalysisProgressListener;
import com.teamscale.core.runtime.api.progress.IProjectAnalysisStateChangeListener;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.CommitChildrenIndex;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.progress.AnalysisProgressIndexBase;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisState;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateBase;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateWithDebugInfo;
import com.teamscale.core.runtime.impl.progress.RevisionAnalysisProgress;
import com.teamscale.core.runtime.impl.scheduling.AssignedJobs;
import com.teamscale.core.runtime.impl.scheduling.JobQueue;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.spi.TeamscaleServiceLoader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.collections.DurableCounterSet;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;

public class ProjectAnalysisProgress {
    private EAnalysisState analysisState;
    private final DurableCounterSet<CommitDescriptor> workDone;
    private final DurableCounterSet<CommitDescriptor> workOpen;
    private final Set<CommitDescriptor> openCostIgnoredCommits;
    private final Map<String, BranchAnalysisStateBase<?>> branchAnalysisStates;
    private final PerformanceIndexBase performanceIndex;
    private final AnalysisProgressIndexBase progressIndex;
    private @Nullable ProjectStorageSystem projectStorageSystem;
    private @Nullable PublicProjectId primaryProjectId;
    private final List<IProjectAnalysisProgressListener> progressListeners;
    private final Set<IProjectAnalysisStateChangeListener> projectAnalysisStateChangeListeners = new HashSet<IProjectAnalysisStateChangeListener>();
    private static final Logger LOGGER = LogManager.getLogger();

    public ProjectAnalysisProgress(PerformanceIndexBase performanceIndex, AnalysisProgressIndexBase progressIndex) throws StorageException {
        this(performanceIndex, progressIndex, null, null);
    }

    public ProjectAnalysisProgress(PerformanceIndexBase performanceIndex, AnalysisProgressIndexBase progressIndex, @Nullable InternalProjectId projectId, IndexLayer indexLayer) throws StorageException {
        this.initializeFieldsForProgressListeners(projectId, indexLayer);
        this.performanceIndex = performanceIndex;
        this.progressIndex = progressIndex;
        this.analysisState = progressIndex.getAnalysisState();
        if (this.analysisState == EAnalysisState.INITIAL_ANALYSIS) {
            performanceIndex.setStateChange(EAnalysisState.INITIAL_ANALYSIS);
        }
        this.openCostIgnoredCommits = progressIndex.createOpenCostIgnoredCommitsSet();
        this.workDone = progressIndex.createWorkDoneSet();
        this.workOpen = progressIndex.createWorkOpenSet();
        this.branchAnalysisStates = progressIndex.loadAllBranchAnalysisStates();
        this.progressListeners = TeamscaleServiceLoader.loadAll(IProjectAnalysisProgressListener.class).toList();
    }

    private void initializeFieldsForProgressListeners(@Nullable InternalProjectId projectId, IndexLayer indexLayer) throws StorageException {
        if (projectId != null && !SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            this.projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)projectId);
            this.primaryProjectId = indexLayer.resolveToPrimaryPublicProjectId((IProjectId)projectId);
        }
    }

    public EAnalysisState getAnalysisState() {
        return this.analysisState;
    }

    public void setAnalysisState(EAnalysisState analysisState) throws StorageException {
        if (analysisState.ordinal() > this.analysisState.ordinal()) {
            this.performanceIndex.setStateChange(analysisState);
        }
        if (this.analysisState != analysisState) {
            this.projectAnalysisStateChangeListeners.forEach(listener -> listener.onProjectAnalysisStateChange(this.analysisState, analysisState));
            this.analysisState = analysisState;
            this.progressIndex.setAnalysisState(analysisState);
        }
    }

    public void registerProjectAnalysisStateChangeListener(IProjectAnalysisStateChangeListener listener) {
        this.projectAnalysisStateChangeListeners.add(listener);
    }

    public void updateProgressForCompletedJob(JobDescriptor job, ITrigger trigger, JobQueue jobQueue, AssignedJobs assignedJobs) throws StorageException {
        CommitDescriptor schedulingCommit = job.getSchedulingCommit();
        if (ProjectAnalysisProgress.isJobIgnoredForCost(job, trigger)) {
            if (schedulingCommit != null) {
                this.openCostIgnoredCommits.add(schedulingCommit);
            }
        } else {
            this.workDone.inc((Serializable)schedulingCommit, trigger.getExpectedCost().getCost());
            this.workOpen.inc((Serializable)schedulingCommit, -trigger.getExpectedOverallCost());
        }
        this.discardUnusedTimestampsForCompletedJob(job, trigger, jobQueue, assignedJobs);
    }

    private void discardUnusedTimestampsForCompletedJob(JobDescriptor job, ITrigger trigger, JobQueue jobQueue, AssignedJobs assignedJobs) throws StorageException {
        SetMap usedTimestamps = new SetMap();
        ProjectAnalysisProgress.insertCommits(assignedJobs.getAllNonNullSchedulingCommits(), (SetMap<String, Long>)usedTimestamps);
        ProjectAnalysisProgress.insertCommits(jobQueue.getAllNonNullSchedulingCommits(), (SetMap<String, Long>)usedTimestamps);
        for (Map.Entry<String, BranchAnalysisStateBase<?>> entry : this.branchAnalysisStates.entrySet()) {
            BranchAnalysisStateBase<?> branchAnalysisState = entry.getValue();
            String branchName = entry.getKey();
            if (branchAnalysisState == null || !branchAnalysisState.discardUnusedTimestampsAndMarkStoresWritten((Set)usedTimestamps.getCollectionOrEmpty((Object)branchName), job, trigger, branchName)) continue;
            this.progressIndex.storeBranchAnalysisState(branchName, branchAnalysisState);
        }
    }

    private static void insertCommits(Collection<CommitDescriptor> commits, SetMap<String, Long> usedTimestamps) {
        for (CommitDescriptor commit : commits) {
            usedTimestamps.add((Object)commit.getBranchName(), (Object)commit.getTimestamp());
        }
    }

    private static boolean isJobIgnoredForCost(JobDescriptor job, ITrigger trigger) {
        return job.getSchedulingCommit() == null || trigger.isPeriodic();
    }

    public void updateProgress(JobDescriptor job, ITrigger trigger, CommitDescriptor schedulingCommit) {
        if (!ProjectAnalysisProgress.isJobIgnoredForCost(job, trigger)) {
            this.workOpen.inc((Serializable)schedulingCommit, trigger.getExpectedOverallCost());
        }
    }

    public List<CommitDescriptor> updateOpenAndDoneWork(Set<CommitDescriptor> unfinishedCommits, PerformanceMetricsIndex.CompletedRevisionSupport completedRevisionSupport) throws StorageException {
        ArrayList<CommitDescriptor> finishedCommits = new ArrayList<CommitDescriptor>();
        for (CommitDescriptor commit2 : new ArrayList(this.workOpen.getKeys())) {
            if (unfinishedCommits.contains(commit2)) continue;
            this.workOpen.remove((Serializable)commit2);
            this.workDone.remove((Serializable)commit2);
            completedRevisionSupport.reportCompletedRevision();
            this.reportCompletedRevisionToListener(commit2);
            if (this.getAnalysisState() == EAnalysisState.INITIAL_ANALYSIS) {
                this.setAnalysisState(EAnalysisState.HISTORY_ANALYSIS);
            }
            finishedCommits.add(commit2);
        }
        this.openCostIgnoredCommits.removeIf(commit -> {
            if (unfinishedCommits.contains(commit)) {
                return false;
            }
            finishedCommits.add((CommitDescriptor)commit);
            return true;
        });
        this.publishProgressToIndex();
        return finishedCommits;
    }

    private void reportCompletedRevisionToListener(CommitDescriptor commitDescriptor) {
        for (IProjectAnalysisProgressListener progressListener : this.progressListeners) {
            try {
                progressListener.reportCompletedRevision(this.getAnalysisState(), commitDescriptor, this.projectStorageSystem, this.primaryProjectId);
            }
            catch (RuntimeException e) {
                LOGGER.error("Progress listener (%s) failed unexpectedly".formatted(progressListener.getClass()), (Throwable)e);
            }
        }
    }

    private void publishProgressToIndex() throws StorageException {
        List progressForOpenCommits = CollectionUtils.map((Collection)this.workOpen.getKeys(), commit -> new RevisionAnalysisProgress((CommitDescriptor)commit, this.workDone.getValue((Serializable)commit), this.workOpen.getValue((Serializable)commit)));
        this.progressIndex.setProgress(progressForOpenCommits, this.branchAnalysisStates.toString());
    }

    public void discardFutureProgress(String branchName, long timestamp) throws StorageException {
        BranchAnalysisStateBase<?> branchAnalysisState = this.getBranchAnalysisState(branchName);
        if (branchAnalysisState.discardFutureProgress(timestamp)) {
            this.progressIndex.storeBranchAnalysisState(branchName, branchAnalysisState);
        }
    }

    public void updateWrittenStores(CommitDescriptor commit, Set<String> writeStores, ScheduledJob nextJob) throws StorageException {
        if (commit == null) {
            return;
        }
        BranchAnalysisStateBase<?> branchAnalysisState = this.getBranchAnalysisState(commit);
        if (branchAnalysisState.updateWrittenStores(commit.getTimestamp(), writeStores, nextJob)) {
            this.progressIndex.storeBranchAnalysisState(commit.getBranchName(), branchAnalysisState);
        }
    }

    private BranchAnalysisStateBase<?> getBranchAnalysisState(CommitDescriptor commit) {
        return this.getBranchAnalysisState(commit.getBranchName());
    }

    private BranchAnalysisStateBase<?> getBranchAnalysisState(String branchName) {
        if (EFeatureToggle.ENABLE_SCHEDULER_STORE_OVERLAP_DEBUG.isEnabled()) {
            return this.branchAnalysisStates.computeIfAbsent(branchName, x -> new BranchAnalysisStateWithDebugInfo());
        }
        return this.branchAnalysisStates.computeIfAbsent(branchName, x -> new BranchAnalysisState());
    }

    public Optional<ConflictInfo> getPotentialConflictInfo(CommitDescriptor schedulingCommit, Set<String> transitiveWriteStores, boolean isPrivilegedTrigger, @Nullable UUID rollbackId, CommitChildrenIndex commitChildrenIndex) throws StorageException {
        if (schedulingCommit == null) {
            return Optional.empty();
        }
        Optional<ConflictInfo> conflictInfo = this.getBranchAnalysisState(schedulingCommit).getConflictInfo(schedulingCommit, transitiveWriteStores, isPrivilegedTrigger, rollbackId, schedulingCommit.getTimestamp());
        if (conflictInfo.isPresent()) {
            return conflictInfo;
        }
        for (CommitDescriptor childCommit : commitChildrenIndex.getChildCommits(schedulingCommit)) {
            if (childCommit.getBranchName().equals(schedulingCommit.getBranchName()) || !(conflictInfo = this.getBranchAnalysisState(childCommit).getConflictInfo(schedulingCommit, transitiveWriteStores, isPrivilegedTrigger, rollbackId, childCommit.getTimestamp() - 1L)).isPresent()) continue;
            return conflictInfo;
        }
        return Optional.empty();
    }

    public static class ConflictInfo {
        private final CommitDescriptor conflictCommit;
        private final String conflictDetails;
        private final UUID rollbackId;

        public ConflictInfo(CommitDescriptor conflictCommit, String conflictDetails, @Nullable UUID rollbackId) {
            this.conflictCommit = conflictCommit;
            this.conflictDetails = conflictDetails;
            this.rollbackId = Objects.requireNonNullElseGet(rollbackId, UUID::randomUUID);
        }

        public CommitDescriptor getConflictCommit() {
            return this.conflictCommit;
        }

        public String getConflictDetails() {
            return this.conflictDetails;
        }

        public UUID getRollbackId() {
            return this.rollbackId;
        }
    }
}

