/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStore;

public class MultiThreadedReadsDelegatingStore
extends DelegatingStore {
    private static final int THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private static final ThreadPoolExecutor THREAD_POOL = new ThreadPoolExecutor(THREAD_POOL_SIZE, THREAD_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    public static final int KEYS_PER_THREAD = Integer.getInteger("com.teamscale.multithreaded_db_reads.keys_per_thread", 500);

    public MultiThreadedReadsDelegatingStore(IStore store) {
        super(store);
    }

    public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
        for (List part : Lists.partition(keys, (int)KEYS_PER_THREAD)) {
            Callable<List> callable = () -> this.store.get(part);
            futures.add(THREAD_POOL.submit(callable));
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (Future future : futures) {
            try {
                result.addAll((Collection)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                MultiThreadedReadsDelegatingStore.handleExceptionFromFuture(e);
            }
        }
        return result;
    }

    public void scan(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (int i = 0; i < prefixes.size(); ++i) {
            byte[] prefix = prefixes.get(i);
            IKeyValueCallback callback = callbacks.get(i);
            Callable<Void> partitionCallable = () -> {
                this.store.scan(prefix, callback);
                return null;
            };
            futures.add(THREAD_POOL.submit(partitionCallable));
        }
        MultiThreadedReadsDelegatingStore.waitForFutures(futures);
    }

    public void scanKeys(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (int i = 0; i < prefixes.size(); ++i) {
            byte[] prefix = prefixes.get(i);
            IKeyValueCallback callback = callbacks.get(i);
            Callable<Void> partitionCallable = () -> {
                this.store.scanKeys(prefix, callback);
                return null;
            };
            futures.add(THREAD_POOL.submit(partitionCallable));
        }
        MultiThreadedReadsDelegatingStore.waitForFutures(futures);
    }

    private static void waitForFutures(List<Future<Void>> futures) throws StorageException {
        for (Future<Void> future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                MultiThreadedReadsDelegatingStore.handleExceptionFromFuture(e);
            }
        }
    }

    private static void handleExceptionFromFuture(Exception e) throws StorageException {
        if (e.getCause() instanceof StorageException) {
            throw (StorageException)e.getCause();
        }
        throw new StorageException((Throwable)e);
    }
}

