/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.analysis.IDeltaTranslatingIndex;
import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.IAnalysisStep;
import com.teamscale.core.analysis.trigger.RollbackRequestedCommitDescriptor;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.interaction.GlobalInteractionLogIndex;
import com.teamscale.core.log.interaction.ProjectInteractionLogIndex;
import com.teamscale.core.log.interaction.ShortInteractionLog;
import com.teamscale.core.log.parse.EParseLogOrigin;
import com.teamscale.core.log.parse.ParseLogEntry;
import com.teamscale.core.log.parse.ParseLogIndex;
import com.teamscale.core.log.worker.GlobalCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.GlobalWorkerLogDigestIndex;
import com.teamscale.core.log.worker.GlobalWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogDigestIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogIndex;
import com.teamscale.core.log.worker.ShortCriticalEventWorkerLog;
import com.teamscale.core.log.worker.WorkerLogData;
import com.teamscale.core.log.worker.WorkerLogDigestIndexBase;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.performance.PerformanceDetailEntry;
import com.teamscale.core.runtime.api.performance.PerformanceIndexBase;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.DeltaIndex;
import com.teamscale.core.runtime.impl.analysis.ETriggerExecutionResult;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.VirtualStoreIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.EPostTriggerSchedulerAction;
import com.teamscale.core.runtime.impl.analysis.trigger.ETriggerType;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.performance.IThreadMemoryMonitor;
import com.teamscale.core.runtime.impl.performance.SectionProfilingMonitor;
import com.teamscale.core.runtime.impl.progress.AnalysisProgressIndexBase;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.rollback.RollbackTrigger;
import com.teamscale.core.runtime.impl.scheduling.AssignedJobs;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.scheduling.TriggerCache;
import com.teamscale.core.runtime.impl.worker.AnalysisTriggerExecutorBase;
import com.teamscale.core.runtime.impl.worker.ICrossProjectLockSupport;
import com.teamscale.core.runtime.impl.worker.ITriggerExecutor;
import com.teamscale.core.runtime.impl.worker.JobExecutionResult;
import com.teamscale.core.runtime.impl.worker.MultiThreadedReadsStorageSystemProviderDecorator;
import com.teamscale.core.runtime.impl.worker.PrivilegedTriggerExecutor;
import com.teamscale.core.runtime.impl.worker.RecordingStore;
import com.teamscale.core.runtime.impl.worker.TriggerExecutionResultWrapper;
import com.teamscale.core.runtime.impl.worker.WorkerAnalysisTriggerExecutor;
import com.teamscale.core.runtime.impl.worker.WorkerThread;
import com.teamscale.core.shutdown.ShutdownLock;
import eu.cqse.check.framework.shallowparser.util.ParseLogMessage;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.core.logging.TeamscaleLogAppender;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.collections.DurableIdGenerator;
import org.conqat.engine.persistence.store.IStorageSystemProviderDecorator;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.profiler.DetailedStorageProfiler;
import org.conqat.engine.persistence.store.profiler.StorageProfiler;
import org.conqat.engine.persistence.store.util.InterruptAwareStorageSystemProviderDecorator;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.lang.SilentAutoClosable;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class WorkerJobExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String THREAD_CONTEXT_JOB_FIELD = "job";
    private static final String THREAD_CONTEXT_TRIGGER_FIELD = "trigger";
    private static final String THREAD_CONTEXT_PROJECT_ID_FIELD = "project";
    private static final String THREAD_CONTEXT_COMMIT_FIELD = "commit";
    private static final int DEFAULT_ACCEPTABLE_JOBS_DURATION_MS = 900000;
    private static final long MAX_JOBS_DURATION = Integer.parseInt(System.getProperty("com.teamscale.worker.max-job-duration", Integer.toString(900000)));
    private final String workerId;
    private final InstanceConfiguration instanceConfiguration;
    private final IndexLayer indexLayer;
    private final PublicProjectId publicProjectId;
    private final DeltaIndex deltaIndex;
    private final VirtualStoreIndex virtualStoreIndex;
    private final ProjectIndex projectIndex;
    private final TriggerCache triggerCache;
    private final ILockProvider lockProvider;
    private final TemporaryDirectory tempDirectory;
    private final ShutdownLock shutdownLock;
    private final DurableIdGenerator idGenerator;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final List<PerformanceDetailEntry.WorkerPerformanceData> supportingThreadPerformance = Collections.synchronizedList(new ArrayList());
    private final Phaser parallelExecutions = new Phaser(1);
    private final List<LogEvent> additionalLogEvents = Collections.synchronizedList(new ArrayList());
    private final AtomicReference<IAnalysisStep> currentlyExecutedStep = new AtomicReference();

    public WorkerJobExecutor(String workerId, InstanceConfiguration instanceConfiguration, IndexLayer indexLayer, PublicProjectId publicProjectId, DeltaIndex deltaIndex, VirtualStoreIndex virtualStoreIndex, ProjectIndex projectIndex, TriggerCache triggerCache, ILockProvider lockProvider, TemporaryDirectory tempDirectory, ShutdownLock shutdownLock, DurableIdGenerator idGenerator, IParallelTaskExecutor parallelTaskExecutor) {
        this.workerId = workerId;
        this.instanceConfiguration = instanceConfiguration;
        this.indexLayer = indexLayer;
        this.publicProjectId = publicProjectId;
        this.deltaIndex = deltaIndex;
        this.virtualStoreIndex = virtualStoreIndex;
        this.projectIndex = projectIndex;
        this.triggerCache = triggerCache;
        this.lockProvider = lockProvider;
        this.tempDirectory = tempDirectory;
        this.shutdownLock = shutdownLock;
        this.idGenerator = idGenerator;
        this.parallelTaskExecutor = parallelTaskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public JobExecutionResult executeJob(ScheduledJob scheduledJob) throws StorageException {
        StorageProfiler storageProfiler = WorkerJobExecutor.createStorageProfiler();
        IndexLayer usedIndexLayer = this.indexLayer.decorate(new MultiThreadedReadsStorageSystemProviderDecorator()).decorate((IStorageSystemProviderDecorator)storageProfiler).decorate((IStorageSystemProviderDecorator)new InterruptAwareStorageSystemProviderDecorator());
        IThreadMemoryMonitor.MEMORY_MONITOR.startRecording(Thread.currentThread().getId());
        SectionProfilingMonitor profilingMonitor = new SectionProfilingMonitor();
        ETriggerExecutionResult executionResult = ETriggerExecutionResult.RUN_SUCCESSFULLY;
        try (SilentAutoClosable ignoredCleanup = WorkerJobExecutor.prepareLoggingEnvironment(scheduledJob, this.publicProjectId);){
            long startTime;
            block22: {
                startTime = System.currentTimeMillis();
                if (WorkerJobExecutor.prepareAndClear(this.tempDirectory, scheduledJob.getJob())) break block22;
                JobExecutionResult jobExecutionResult = new JobExecutionResult(JobExecutionResult.EJobResult.RESCHEDULE_REQUESTED);
                try {
                    this.logPerformanceData(scheduledJob.getJob(), startTime, storageProfiler, profilingMonitor, executionResult);
                }
                catch (StorageException e) {
                    LOGGER.error("Failed to store performance data", (Throwable)e);
                }
                return jobExecutionResult;
            }
            JobExecutionResult jobExecutionResult = this.executeTrigger(scheduledJob, startTime, usedIndexLayer, profilingMonitor);
            try {
                this.logPerformanceData(scheduledJob.getJob(), startTime, storageProfiler, profilingMonitor, executionResult);
            }
            catch (StorageException e) {
                LOGGER.error("Failed to store performance data", (Throwable)e);
            }
            return jobExecutionResult;
            catch (Throwable t) {
                JobExecutionResult jobExecutionResult2;
                block23: {
                    executionResult = ETriggerExecutionResult.FAILED_BADLY;
                    LOGGER.fatal("Had a serious error during trigger execution: {}", (Object)t.getMessage(), (Object)t);
                    LOGGER.fatal("This might indicate inconsistencies between the scheduler and the worker.");
                    LOGGER.fatal(this.buildRunningJobsMessage(scheduledJob, usedIndexLayer));
                    this.logFatalException(scheduledJob.getJob(), startTime, t);
                    jobExecutionResult2 = new JobExecutionResult(JobExecutionResult.EJobResult.COMPLETED_WITH_UNRECOVERABLE_ERROR);
                    try {
                        this.logPerformanceData(scheduledJob.getJob(), startTime, storageProfiler, profilingMonitor, executionResult);
                    }
                    catch (StorageException e) {
                        LOGGER.error("Failed to store performance data", (Throwable)e);
                    }
                    if (ignoredCleanup == null) break block23;
                    ignoredCleanup.close();
                }
                return jobExecutionResult2;
                {
                    catch (Throwable throwable) {
                        try {
                            this.logPerformanceData(scheduledJob.getJob(), startTime, storageProfiler, profilingMonitor, executionResult);
                        }
                        catch (StorageException e) {
                            LOGGER.error("Failed to store performance data", (Throwable)e);
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    private String buildRunningJobsMessage(ScheduledJob scheduledJob, IndexLayer usedIndexLayer) throws StorageException {
        AssignedJobs assignedJobs = new AssignedJobs(AnalysisProgressIndexBase.open(usedIndexLayer, (IProjectId)scheduledJob.getProjectId()));
        StringBuilder errorMessage = new StringBuilder("Jobs currently running in project '").append(this.indexLayer.resolveToPrimaryPublicProjectId((IProjectId)scheduledJob.getProjectId())).append("' (").append(scheduledJob.getProjectId()).append("):\n");
        for (ScheduledJob job : assignedJobs.getAllJobs()) {
            errorMessage.append("\t");
            if (job.equals(scheduledJob)) {
                errorMessage.append("[FAILING JOB] ");
            }
            errorMessage.append(job).append("\n");
        }
        return errorMessage.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobExecutionResult executeTrigger(ScheduledJob scheduledJob, long startTime, IndexLayer usedIndexLayer, IProfilingMonitor profilingMonitor) throws ConQATException, TriggerCompilationException, IOException {
        try {
            LOGGER.info("Starting job at {}", (Object)startTime);
            ITriggerExecutor executor = switch (scheduledJob.getJob().getTriggerType()) {
                default -> throw new MatchException(null, null);
                case ETriggerType.PRIVILEGED -> this.executePrivilegedTrigger(scheduledJob, usedIndexLayer, profilingMonitor);
                case ETriggerType.BLOCK -> this.executeBlockBasedTrigger(scheduledJob, usedIndexLayer, profilingMonitor);
            };
            JobExecutionResult jobExecutionResult = this.buildJobExecutionResult(scheduledJob, startTime, executor);
            return jobExecutionResult;
        }
        finally {
            LOGGER.info("Finished job at {}", (Object)System.currentTimeMillis());
        }
    }

    private WorkerAnalysisTriggerExecutor executeBlockBasedTrigger(ScheduledJob scheduledJob, IndexLayer indexLayer, IProfilingMonitor profilingMonitor) throws ConQATException, TriggerCompilationException {
        ITrigger trigger = this.triggerCache.findTrigger(scheduledJob.getJob()).orElseThrow(() -> new ConQATException("Job references invalid trigger: " + scheduledJob.getTriggerName()));
        AnalysisTrigger analysisTrigger = (AnalysisTrigger)CCSMAssert.checkedCast((Object)trigger, AnalysisTrigger.class);
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)scheduledJob.getProjectId());
        WorkerAnalysisTriggerExecutor executor = new WorkerAnalysisTriggerExecutor(scheduledJob, analysisTrigger.getDescription(), this.tempDirectory.getPath(), this.deltaIndex, this.virtualStoreIndex, this.idGenerator, projectStorageSystem, this.parallelTaskExecutor, this.lockProvider);
        executor.setProfilingMonitor(profilingMonitor);
        ICrossProjectLockSupport crossProjectLockSupport = ICrossProjectLockSupport.createForProject(scheduledJob.getProjectId(), this.projectIndex, this.lockProvider);
        executor.execute(this.triggerCache, projectStorageSystem, indexLayer.openGlobalStorageSystem(), crossProjectLockSupport, this::withAnalysisStep);
        return executor;
    }

    private PrivilegedTriggerExecutor executePrivilegedTrigger(ScheduledJob scheduledJob, IndexLayer indexLayer, IProfilingMonitor profilingMonitor) throws TriggerCompilationException, StorageException, IOException {
        PrivilegedTriggerExecutor executor = new PrivilegedTriggerExecutor(scheduledJob, indexLayer, this.lockProvider, this.instanceConfiguration, this.tempDirectory.getPath(), this.parallelTaskExecutor, profilingMonitor);
        executor.execute(this::withAnalysisStep);
        return executor;
    }

    private static @NonNull StorageProfiler createStorageProfiler() {
        if (WorkerThread.LOG_PERFORMANCE_DETAILS) {
            return new DetailedStorageProfiler(false);
        }
        return new StorageProfiler();
    }

    private static SilentAutoClosable prepareLoggingEnvironment(ScheduledJob scheduledJob, PublicProjectId publicProjectId) {
        ThreadContext.put((String)THREAD_CONTEXT_JOB_FIELD, (String)"%s/%s (@%s)".formatted(publicProjectId, scheduledJob.getTriggerName(), scheduledJob.getSchedulingCommit()));
        ThreadContext.put((String)THREAD_CONTEXT_TRIGGER_FIELD, (String)scheduledJob.getTriggerName());
        ThreadContext.put((String)THREAD_CONTEXT_PROJECT_ID_FIELD, (String)scheduledJob.getProjectId().toString());
        ThreadContext.put((String)THREAD_CONTEXT_COMMIT_FIELD, (String)String.valueOf(scheduledJob.getSchedulingCommit()));
        return () -> {
            ThreadContext.remove((String)"context");
            ThreadContext.remove((String)THREAD_CONTEXT_COMMIT_FIELD);
            ThreadContext.remove((String)THREAD_CONTEXT_PROJECT_ID_FIELD);
            ThreadContext.remove((String)THREAD_CONTEXT_TRIGGER_FIELD);
            ThreadContext.remove((String)THREAD_CONTEXT_JOB_FIELD);
        };
    }

    public static void setAdditionalLog4jContext(String contextInformation) {
        ThreadContext.put((String)"context", (String)contextInformation);
    }

    private static JobExecutionResult.EJobResult determineSuccessfulResult(ITrigger trigger) {
        if (trigger.getPostTriggerSchedulerAction() == EPostTriggerSchedulerAction.DELETE_PROJECT) {
            return JobExecutionResult.EJobResult.COMPLETED_WITH_PROJECT_DELETION;
        }
        return JobExecutionResult.EJobResult.COMPLETED_SUCCESSFULLY;
    }

    private void logCriticalEvent(JobDescriptor job, long startTime) throws StorageException {
        if (!job.isCritical()) {
            return;
        }
        InternalProjectId projectId = job.getInternalProjectId();
        ShortCriticalEventWorkerLog shortLog = new ShortCriticalEventWorkerLog(this.workerId, projectId, job.getTriggerName(), LogEntryIdentifier.freshWithTimestamp(startTime), System.currentTimeMillis(), WorkerJobExecutor.replaceRollbackRequestedCommitDescriptor(job), job.getSchedulingReason(), job.getRollbackId());
        if (SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            this.indexLayer.openGlobalIndex(GlobalCriticalEventWorkerLogIndex.class).insertWorkerLog(shortLog);
        } else {
            ProjectCriticalEventWorkerLogIndex index = this.indexLayer.openNonHistorizedProjectIndex(ProjectCriticalEventWorkerLogIndex.class, (IProjectId)projectId);
            index.insertWorkerLog(shortLog);
        }
    }

    @VisibleForTesting
    static @Nullable CommitDescriptor replaceRollbackRequestedCommitDescriptor(JobDescriptor job) {
        CommitDescriptor schedulingCommit = job.getSchedulingCommit();
        if (!job.getTriggerName().equals(RollbackTrigger.class.getName())) {
            return schedulingCommit;
        }
        if (!(schedulingCommit instanceof RollbackRequestedCommitDescriptor)) {
            return schedulingCommit;
        }
        UnmodifiableList<CommitDescriptor> schedulingHints = ((RollbackRequestedCommitDescriptor)schedulingCommit).getSchedulingHints();
        if (schedulingHints.isEmpty()) {
            return null;
        }
        return (CommitDescriptor)schedulingHints.getFirst();
    }

    private void insertWorkerLogIntoIndex(JobDescriptor job, WorkerLogData workerLogData) throws StorageException {
        InternalProjectId projectId = job.getInternalProjectId();
        if (SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            this.indexLayer.openGlobalIndex(GlobalWorkerLogIndex.class).insertWorkerLog(workerLogData);
            WorkerJobExecutor.insertLogEntryDigest((SupplierWithException<WorkerLogDigestIndexBase, StorageException>)((SupplierWithException)() -> this.indexLayer.openGlobalIndex(GlobalWorkerLogDigestIndex.class)), workerLogData);
        } else {
            this.indexLayer.openNonHistorizedProjectIndex(ProjectWorkerLogIndex.class, (IProjectId)projectId).insertWorkerLog(workerLogData);
            WorkerJobExecutor.insertLogEntryDigest((SupplierWithException<WorkerLogDigestIndexBase, StorageException>)((SupplierWithException)() -> this.indexLayer.openNonHistorizedProjectIndex(ProjectWorkerLogDigestIndex.class, (IProjectId)projectId)), workerLogData);
        }
    }

    private static void insertLogEntryDigest(SupplierWithException<WorkerLogDigestIndexBase, StorageException> digestIndexSupplier, WorkerLogData workerLogData) throws StorageException {
        if (!workerLogData.hasErrorsOrWarnings()) {
            return;
        }
        ((WorkerLogDigestIndexBase)((Object)digestIndexSupplier.get())).insertDigestForLogEntry(workerLogData);
    }

    private JobExecutionResult buildJobExecutionResult(ScheduledJob scheduledJob, long startTime, ITriggerExecutor executor) throws StorageException {
        this.shutdownLock.enterNoShutdownRegion();
        this.logExecutionResults(scheduledJob, startTime, executor);
        CommitDescriptor outputCommit = executor.getCommit().orElse(null);
        TriggerExecutionResultWrapper executionResult = executor.getExecutionResult();
        if (executionResult.state == ETriggerExecutionResult.RUN_SUCCESSFULLY) {
            return this.buildJobExecutionResult(scheduledJob, executor, outputCommit);
        }
        this.virtualStoreIndex.discardVirtualStores(executor.getWrittenVirtualStoreNameToId().values());
        return switch (executionResult.state) {
            default -> throw new MatchException(null, null);
            case ETriggerExecutionResult.RESCHEDULE_REQUESTED -> new JobExecutionResult(JobExecutionResult.EJobResult.RESCHEDULE_REQUESTED, outputCommit, null, null, executionResult.earliestRescheduleTimestamp);
            case ETriggerExecutionResult.ROLLBACK_REQUESTED -> new JobExecutionResult(JobExecutionResult.EJobResult.ROLLBACK_REQUESTED, outputCommit);
            case ETriggerExecutionResult.FAILED_BADLY -> new JobExecutionResult(JobExecutionResult.EJobResult.COMPLETED_WITH_ERROR, outputCommit);
            case ETriggerExecutionResult.RUN_SUCCESSFULLY -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)executionResult.state));
        };
    }

    private JobExecutionResult buildJobExecutionResult(ScheduledJob scheduledJob, ITriggerExecutor executor, CommitDescriptor outputCommit) throws StorageException {
        PairList<String, Long> outputDeltas = null;
        Map<String, Long> virtualStores = null;
        if (outputCommit == null || outputCommit instanceof RollbackRequestedCommitDescriptor) {
            this.virtualStoreIndex.discardVirtualStores(executor.getWrittenVirtualStoreNameToId().values());
        } else if (executor instanceof AnalysisTriggerExecutorBase) {
            AnalysisTriggerExecutorBase analysisTriggerExecutor = (AnalysisTriggerExecutorBase)((Object)executor);
            outputDeltas = this.dumpDeltas(analysisTriggerExecutor.recordingStores, analysisTriggerExecutor.getOpenIndexes(), scheduledJob, analysisTriggerExecutor.getTrigger().getMaxOutputDeltaSize());
            virtualStores = executor.getWrittenVirtualStoreNameToId();
        }
        return new JobExecutionResult(WorkerJobExecutor.determineSuccessfulResult(executor.getTrigger()), outputCommit, outputDeltas, virtualStores, 0L);
    }

    private void logExecutionResults(ScheduledJob scheduledJob, long startTime, ITriggerExecutor executor) throws StorageException {
        JobDescriptor job = scheduledJob.getJob();
        if (SchedulingConstants.isDeleteOrReanalyze(job)) {
            return;
        }
        List<LogEvent> loggingEvents = this.mergeLogEvents(executor);
        List<LogEvent> nonParseLogEvents = this.filterAndHandleParsingErrors(job, loggingEvents);
        WorkerLogData workerLogData = WorkerLogData.create(this.workerId, startTime, job, job.getInternalProjectId(), LoggingEventTransport.convertFromLog4j(nonParseLogEvents), executor.getInputDeltas(), executor.getExecutionResult().state);
        this.logCriticalEvent(job, startTime);
        this.logInteractions(job, nonParseLogEvents);
        this.insertWorkerLogIntoIndex(job, workerLogData);
    }

    private List<LogEvent> mergeLogEvents(ITriggerExecutor executor) {
        if (this.additionalLogEvents.isEmpty()) {
            return new ArrayList<LogEvent>((Collection<LogEvent>)executor.getLoggingEvents());
        }
        ArrayList<LogEvent> loggingEvents = new ArrayList<LogEvent>((Collection<LogEvent>)executor.getLoggingEvents());
        loggingEvents.addAll(this.additionalLogEvents);
        loggingEvents.sort(Comparator.comparingLong(LogEvent::getTimeMillis));
        return loggingEvents;
    }

    private void logInteractions(JobDescriptor job, List<LogEvent> logEvents) throws StorageException {
        List interactionLogEvents = CollectionUtils.filter(logEvents, LoggingUtils::isInteractionLog);
        if (interactionLogEvents.isEmpty()) {
            return;
        }
        InternalProjectId projectId = job.getInternalProjectId();
        if (SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            this.indexLayer.openGlobalIndex(GlobalInteractionLogIndex.class).insertInteractionLogs(ShortInteractionLog.convert(job.getTriggerName(), job.getSchedulingCommit(), SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, interactionLogEvents));
        } else {
            this.indexLayer.openNonHistorizedProjectIndex(ProjectInteractionLogIndex.class, (IProjectId)projectId).insertInteractionLogs(ShortInteractionLog.convert(job.getTriggerName(), job.getSchedulingCommit(), projectId, interactionLogEvents));
        }
    }

    private List<LogEvent> filterAndHandleParsingErrors(JobDescriptor job, List<LogEvent> logEvents) throws StorageException {
        ArrayList<LogEvent> parseLogEvents = new ArrayList<LogEvent>();
        ArrayList<LogEvent> otherEvents = new ArrayList<LogEvent>();
        for (LogEvent logEvent : logEvents) {
            if (LoggingUtils.isParseLog((LogEvent)logEvent)) {
                parseLogEvents.add(logEvent);
                continue;
            }
            otherEvents.add(logEvent);
        }
        if (parseLogEvents.isEmpty()) {
            return logEvents;
        }
        if (PreCommitUtils.isPrecommitJob(job)) {
            return otherEvents;
        }
        List<ParseLogEntry> logEntries = WorkerJobExecutor.convertToParseLogEntries(parseLogEvents, job.getSchedulingCommit());
        InternalProjectId projectId = job.getInternalProjectId();
        this.indexLayer.openNonHistorizedProjectIndex(ParseLogIndex.class, (IProjectId)projectId).persistLogEntries(logEntries);
        return otherEvents;
    }

    public static @NonNull List<ParseLogEntry> convertToParseLogEntries(List<LogEvent> parseLogEvents, @Nullable CommitDescriptor commit) {
        ArrayList<ParseLogEntry> logEntries = new ArrayList<ParseLogEntry>();
        for (LogEvent event : parseLogEvents) {
            ParseLogMessage message = (ParseLogMessage)event.getMessage();
            logEntries.add(new ParseLogEntry(EParseLogOrigin.valueOf(message.getParseLogOriginStep()), message.getFormattedMessage(), message.getUniformPath(), commit, message.getLineNumber()));
        }
        return logEntries;
    }

    private static boolean prepareAndClear(TemporaryDirectory tempDirectory, JobDescriptor job) {
        try {
            FileSystemUtils.ensureDirectoryExists((Path)tempDirectory.getPath());
            tempDirectory.clear();
            return true;
        }
        catch (Exception e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed to clear temp dir. Rescheduling job {} to retry later. This might delay the job indefinitely. If this error seems systemic, please contact support@cqse.eu.", (Object)job);
            return false;
        }
    }

    private PairList<String, Long> dumpDeltas(PairList<String, RecordingStore> recordingStores, UnmodifiableMap<String, IStorageIndex> openIndexes, ScheduledJob scheduledJob, int maxDeltaSize) throws StorageException {
        PairList outputDeltas = new PairList();
        PairList deltasToWrite = new PairList();
        for (int i = 0; i < recordingStores.size(); ++i) {
            String storeName;
            IIndexDelta resolvedDelta;
            KeyDelta keyDelta = ((RecordingStore)((Object)recordingStores.getSecond(i))).obtainDelta();
            if (keyDelta.isEmpty() || (resolvedDelta = WorkerJobExecutor.resolveDelta((IStorageIndex)openIndexes.get((Object)(storeName = (String)recordingStores.getFirst(i))), keyDelta, storeName)).isEmpty()) continue;
            for (IIndexDelta iIndexDelta : WorkerJobExecutor.splitDeltaIfNecessary(resolvedDelta, maxDeltaSize)) {
                CCSMAssert.isFalse((boolean)iIndexDelta.isEmpty(), (String)"Obtained empty delta");
                CCSMAssert.isTrue((boolean)resolvedDelta.getClass().isAssignableFrom(iIndexDelta.getClass()), () -> "Obtained delta of a different type, expected %s but got %s".formatted(resolvedDelta.getClass(), delta.getClass()));
                long deltaId = this.idGenerator.getNextId();
                deltasToWrite.add((Object)deltaId, (Object)iIndexDelta);
                outputDeltas.add((Object)storeName, (Object)deltaId);
            }
        }
        if (!deltasToWrite.isEmpty()) {
            this.deltaIndex.putDeltas((PairList<Long, IIndexDelta>)deltasToWrite);
        }
        LOGGER.debug(() -> "Output job: " + String.valueOf(scheduledJob.getJob()) + " (" + String.valueOf(scheduledJob.getInputDeltaStoreNames()) + " -> " + String.valueOf(outputDeltas.extractFirstList()));
        return outputDeltas;
    }

    private static IIndexDelta resolveDelta(IStorageIndex index, KeyDelta keyDelta, String storeName) throws StorageException {
        if (!(index instanceof IDeltaTranslatingIndex)) {
            return keyDelta;
        }
        IDeltaTranslatingIndex deltaTranslatingIndex = (IDeltaTranslatingIndex)index;
        Object resolvedDelta = deltaTranslatingIndex.resolveDelta(keyDelta);
        CCSMAssert.isNotNull(resolvedDelta, () -> "Index %s (%s) resolved the delta to null. Should be empty instead.".formatted(storeName, index.getClass()));
        CCSMAssert.isFalse((boolean)(resolvedDelta instanceof KeyDelta), () -> "Index %s (%s) illegally created %s".formatted(storeName, index.getClass(), KeyDelta.class));
        return resolvedDelta;
    }

    private static List<? extends IIndexDelta> splitDeltaIfNecessary(IIndexDelta baseDelta, int maxDeltaSize) {
        if (baseDelta.size() > maxDeltaSize) {
            return baseDelta.split(maxDeltaSize);
        }
        return List.of(baseDelta);
    }

    private void logFatalException(JobDescriptor job, long startTime, Throwable t) throws StorageException {
        LoggingEventTransport loggingEvent = LoggingEventTransport.of((String)StringUtils.obtainStackTrace((Throwable)t), (ELogLevel)ELogLevel.FATAL);
        CommitDescriptor commit = job.getSchedulingCommit();
        if (commit == null) {
            commit = CommitDescriptor.createUnbranchedDescriptor((long)1L);
        }
        this.insertWorkerLogIntoIndex(job, WorkerLogData.create(this.workerId, startTime, job, job.getInternalProjectId(), commit, Collections.singletonList(loggingEvent), Collections.emptyList(), ETriggerExecutionResult.FAILED_BADLY));
    }

    private void logPerformanceData(JobDescriptor job, long startTime, StorageProfiler storageProfiler, SectionProfilingMonitor profilingMonitor, ETriggerExecutionResult eTriggerExecutionResult) throws StorageException {
        PerformanceIndexBase performanceIndex = PerformanceIndexBase.open(this.indexLayer, (IProjectId)job.getInternalProjectId());
        long durationMillis = System.currentTimeMillis() - startTime;
        InternalProjectId projectId = job.getInternalProjectId();
        EAnalysisState analysisState = EAnalysisState.LIVE_ANALYSIS;
        if (!SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            analysisState = this.indexLayer.openNonHistorizedProjectIndex(ProjectAnalysisProgressIndex.class, (IProjectId)job.getInternalProjectId()).getAnalysisState();
            if (durationMillis > MAX_JOBS_DURATION) {
                WorkerLogData workerLogData = WorkerLogData.create(this.workerId, startTime, job, projectId, List.of(LoggingEventTransport.of((String)("Job took " + durationMillis + " milliseconds, which is longer than " + MAX_JOBS_DURATION + " milliseconds . To change the acceptable duration, set the JVM flag: com.teamscale.worker.max-job-duration to a different millisecond threshold."), (ELogLevel)ELogLevel.WARN)), Collections.emptyList(), eTriggerExecutionResult);
                this.insertWorkerLogIntoIndex(job, workerLogData);
            }
        }
        if (!this.shouldLogPerformanceData(job)) {
            return;
        }
        PerformanceDetailEntry entry = new PerformanceDetailEntry(analysisState, job.getTriggerName(), this.indexLayer.resolveToPrimaryPublicProjectId((IProjectId)job.getInternalProjectId()), job.getSchedulingCommit(), new PerformanceDetailEntry.WorkerPerformanceData(this.workerId, Instant.ofEpochMilli(startTime), Duration.ofMillis(durationMillis), IThreadMemoryMonitor.MEMORY_MONITOR.getMaxMemoryBytes(Thread.currentThread().getId())), this.supportingThreadPerformance, storageProfiler.getNumberOfCalls(), storageProfiler.getTimeMillis());
        profilingMonitor.appendToEntry(entry);
        if (WorkerThread.LOG_PERFORMANCE_DETAILS) {
            entry.setStoreOperationStatisticsByStore(((DetailedStorageProfiler)storageProfiler).getOperationStatisticsByStore());
            performanceIndex.addDetailEntry(entry);
        }
        performanceIndex.updateAggregate(entry);
    }

    private boolean shouldLogPerformanceData(JobDescriptor job) {
        if (job.getTriggerType() != ETriggerType.PRIVILEGED) {
            return true;
        }
        try {
            EPostTriggerSchedulerAction postTriggerSchedulerAction = this.triggerCache.getTrigger(job).getPostTriggerSchedulerAction();
            return postTriggerSchedulerAction != EPostTriggerSchedulerAction.DELETE_PROJECT && postTriggerSchedulerAction != EPostTriggerSchedulerAction.REANALYZE_PROJECT;
        }
        catch (TriggerCompilationException e) {
            return false;
        }
    }

    SilentAutoClosable registerParallelExecution(String supportingWorkerId, ScheduledJob scheduledJob) {
        TeamscaleLogAppender.init();
        SilentAutoClosable loggingCleanup = WorkerJobExecutor.prepareLoggingEnvironment(scheduledJob, this.publicProjectId);
        this.parallelExecutions.register();
        Instant startTime = DateTimeUtils.now();
        return ((SilentAutoClosable)() -> {
            this.appendParallelExecutionData((UnmodifiableList<LogEvent>)TeamscaleLogAppender.getLogEvents(), startTime, supportingWorkerId);
            this.parallelExecutions.arriveAndDeregister();
        }).andThen(loggingCleanup);
    }

    private void appendParallelExecutionData(UnmodifiableList<LogEvent> logEvents, Instant startTime, String workerId) {
        this.additionalLogEvents.addAll((Collection<LogEvent>)logEvents);
        this.supportingThreadPerformance.add(new PerformanceDetailEntry.WorkerPerformanceData(workerId, startTime, Duration.between(startTime, DateTimeUtils.now()), IThreadMemoryMonitor.MEMORY_MONITOR.getMaxMemoryBytes(Thread.currentThread().getId())));
    }

    private void awaitParallelExecutions() {
        this.parallelExecutions.arriveAndAwaitAdvance();
    }

    private SilentAutoClosable withAnalysisStep(IAnalysisStep step) {
        if (!this.currentlyExecutedStep.compareAndSet(null, step)) {
            throw new IllegalStateException("There is already a different step being executed");
        }
        return () -> {
            this.awaitParallelExecutions();
            if (!this.currentlyExecutedStep.compareAndSet(step, null)) {
                throw new IllegalStateException("Unable to unset step %s as a different one is being executed.".formatted(step));
            }
        };
    }

    public void cancelStep(boolean interrupt) {
        ICancelable delegate = this.currentlyExecutedStep.get();
        if (delegate == null) {
            return;
        }
        delegate.cancel(interrupt);
    }
}

