/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs.wiql;

import com.teamscale.core.tfs.wiql.CollectionWiqlWhereClause;
import com.teamscale.core.tfs.wiql.CombinedWiqlWhereClause;
import com.teamscale.core.tfs.wiql.EWiqlWhereClauseCombinator;
import com.teamscale.core.tfs.wiql.FieldBasedWiqlWhereClause;
import com.teamscale.core.tfs.wiql.IWiqlWhereOperator;
import com.teamscale.core.tfs.wiql.SimpleWiqlWhereClause;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract sealed class WiqlWhereClause
permits CombinedWiqlWhereClause, FieldBasedWiqlWhereClause {
    protected abstract boolean isValid();

    protected abstract boolean isEmpty();

    protected abstract String toWiqlString();

    public abstract WiqlWhereClause negated();

    public String toString() {
        return this.toWiqlString();
    }

    public static WiqlWhereClause simple(String field, IWiqlWhereOperator.EWiqlSimpleOperator operator, @Nullable String value) {
        return new SimpleWiqlWhereClause(field, operator, value);
    }

    public static WiqlWhereClause collection(String field, IWiqlWhereOperator.EWiqlCollectionOperator operator, Collection<String> values) {
        return new CollectionWiqlWhereClause(field, operator, values);
    }

    public static WiqlWhereClause combine(EWiqlWhereClauseCombinator combinator, Collection<? extends WiqlWhereClause> clauses) {
        if (clauses.size() == 1) {
            return clauses.iterator().next();
        }
        return new CombinedWiqlWhereClause(clauses, combinator);
    }
}

