/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.user;

import com.teamscale.core.authenticate.AuthenticationManager;
import com.teamscale.core.authenticate.AuthenticationRequestHandler;
import com.teamscale.core.permissions.PermissionCache;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UsersByMailCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.cache.IndexWithCache;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="users", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP, EStorageOption.ENCRYPTED})
@IndexWithCache(value={PermissionCache.class, UsersByMailCache.class})
public class UserIndex
implements IGlobalIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String INDEX_NAME = "users";
    public static final Pattern USERNAME_FORBIDDEN_CHARACTERS_REGEX = Pattern.compile("\\s+.*|.*\\s|.*[#/,\\r\\n]+.*");
    public static final Set<String> RESERVED_USERNAMES = Set.of("prometheus-monitoring-internal-teamscale-user");
    private final SynchronizedCacheAccess<PermissionCache> permissionCacheAccess;
    private final SynchronizedCacheAccess<UsersByMailCache> usersByMailCacheAccess;
    private final ValueIndex<User> delegate;
    private final SimpleCrudIndex<SimpleCrudIndex.ESingletonKey, Integer> enabledUsersDelegate;
    private final SimpleCrudIndex<SimpleCrudIndex.ESingletonKey, Long> lastChangeTimestampDelegate;

    public UserIndex(IStore store, SynchronizedCacheAccess<PermissionCache> permissionCacheAccess, SynchronizedCacheAccess<UsersByMailCache> usersByMailCacheAccess) {
        this.delegate = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, INDEX_NAME));
        this.enabledUsersDelegate = SimpleCrudIndex.forSingleKey((IStore)new DelegatingPartitionStore(store, "enabled-users"), (ISerializer)ISerializer.forInteger());
        this.lastChangeTimestampDelegate = SimpleCrudIndex.forSingleKey((IStore)new DelegatingPartitionStore(store, "last-change"), (ISerializer)ISerializer.forLong());
        this.permissionCacheAccess = permissionCacheAccess;
        this.usersByMailCacheAccess = usersByMailCacheAccess;
    }

    public @Nullable User getUser(String username) throws StorageException {
        return (User)this.delegate.getValue(username.toLowerCase());
    }

    public List<@Nullable User> getUsers(List<String> usernames) throws StorageException {
        return this.delegate.getValues(StringUtils.lowercaseList(usernames));
    }

    public List<User> getUsersForMail(String mail) throws StorageException {
        return (List)this.usersByMailCacheAccess.getOrUpdate(cache -> {
            if (!cache.isInitialized()) {
                this.delegate.getAllEntries().getSecondList().forEach(cache::addUser);
            }
            Set<String> usernames = cache.getUsernames(mail);
            return this.getUsers(new ArrayList<String>(usernames)).stream().filter(Objects::nonNull).toList();
        });
    }

    private void clearCachesForUsers(List<String> users, IMessageBroker messageBroker, String reason) {
        AuthenticationRequestHandler.invalidateSessionCacheForUsers(users, messageBroker);
        AuthenticationRequestHandler.clearAccessTokenCache(messageBroker);
        this.permissionCacheAccess.invalidate(reason);
        this.usersByMailCacheAccess.invalidate(reason);
    }

    public void setUser(User user, IMessageBroker messageBroker) throws StorageException {
        this.setUsers(Collections.singletonList(user), messageBroker);
        this.updateLastChangeTimestamp();
    }

    public void setUsers(List<User> users, IMessageBroker messageBroker) throws StorageException {
        PairList lowerCaseCopy = new PairList();
        for (User user : users) {
            lowerCaseCopy.add((Object)user.getUsername().toLowerCase(), (Object)user);
            if (USERNAME_FORBIDDEN_CHARACTERS_REGEX.matcher(user.getUsername()).matches()) {
                LOGGER.warn("User with invalid username entered in database: {}", (Object)user.getUsername());
            }
            if (user.getAuthenticator() != null) continue;
            LOGGER.warn("User without authenticator entered in database: {}", (Object)user.getUsername());
        }
        List lowerCaseUserNames = lowerCaseCopy.extractFirstList();
        this.delegate.setValues(lowerCaseCopy);
        this.deleteEnabledUserCount();
        this.clearCachesForUsers(lowerCaseUserNames, messageBroker, "Users set in UserIndex: " + String.valueOf(lowerCaseUserNames));
        this.updateLastChangeTimestamp();
    }

    private void updateLastChangeTimestamp() throws StorageException {
        this.lastChangeTimestampDelegate.put((Object)SimpleCrudIndex.ESingletonKey.INSTANCE, (Object)DateTimeUtils.zonedNow().toInstant().toEpochMilli());
    }

    public long getLastChangeTimestamp() throws StorageException {
        return this.lastChangeTimestampDelegate.get((Object)SimpleCrudIndex.ESingletonKey.INSTANCE).orElse(0L);
    }

    public void removeUser(String username, IMessageBroker messageBroker) throws StorageException {
        this.delegate.removeValue(username.toLowerCase());
        this.deleteEnabledUserCount();
        this.clearCachesForUsers(Collections.singletonList(username), messageBroker, "User removed: " + username);
        this.updateLastChangeTimestamp();
    }

    private static boolean isUserEnabled(@Nullable User user) {
        if (user == null) {
            return false;
        }
        if (user.getAuthenticator() == null) {
            return false;
        }
        String authenticatorName = AuthenticationManager.getAuthenticatorName(user.getAuthenticator());
        return AuthenticationManager.getInstance().authenticatorAllowsLogin(authenticatorName);
    }

    public int getEnabledUserCount() throws StorageException {
        return (Integer)this.enabledUsersDelegate.computeLocked("", () -> {
            Optional userCount = this.enabledUsersDelegate.get((Object)SimpleCrudIndex.ESingletonKey.INSTANCE);
            if (userCount.isEmpty()) {
                return this.calculateEnabledUserCount();
            }
            return (Integer)userCount.get();
        });
    }

    private int calculateEnabledUserCount() throws StorageException {
        int count = (int)this.getAllUsers().stream().filter(UserIndex::isUserEnabled).count();
        this.enabledUsersDelegate.runLocked("", () -> this.enabledUsersDelegate.put((Object)SimpleCrudIndex.ESingletonKey.INSTANCE, (Object)count));
        return count;
    }

    public void deleteEnabledUserCount() throws StorageException {
        this.enabledUsersDelegate.runLocked("", () -> this.enabledUsersDelegate.remove((Object)SimpleCrudIndex.ESingletonKey.INSTANCE));
    }

    public boolean isEmpty() throws StorageException {
        return this.delegate.getAllKeys().isEmpty();
    }

    public List<User> getAllUsers() throws StorageException {
        return this.delegate.getAllEntries().extractSecondList();
    }

    public List<String> getAllUserNames() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public PairList<String, User> getAllEntries() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public <E extends Exception> void runWithUserUpdateLock(String username, RunnableWithException<E> operation) throws E {
        this.delegate.runLocked(username, operation);
    }

    public <R, E extends Exception> R computeWithUserUpdateLock(String username, SupplierWithException<R, E> computation) throws E {
        return (R)this.delegate.computeLocked(username, computation);
    }
}

