/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.option;

import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.option.CheckOptionBase;
import java.lang.reflect.Field;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.reflect.ReflectionUtils;

public class FieldAnnotationBasedCheckOption<T>
extends CheckOptionBase<T> {
    private final Field field;

    public FieldAnnotationBasedCheckOption(CheckOption annotation, Field field, T defaultValue, Class<T> type) {
        super(annotation.name(), annotation.description(), annotation.multilineText(), type, defaultValue);
        CCSMAssert.isTrue((boolean)ReflectionUtils.isAssignable(type, field.getType()), (String)"The given field must be assignable from the given type.");
        this.field = field;
    }

    @Override
    public void setOption(CheckImplementationBase check, T value) {
        try {
            this.field.set(check, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            CCSMAssert.fail((String)("Failed to set option: " + e.getMessage()));
        }
    }
}

