/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.registry;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.CheckInfo;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.option.FieldAnnotationBasedCheckOption;
import eu.cqse.check.framework.core.option.ICheckOption;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.core.registry.CheckMappingUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.typetracker.TypeTrackerFactory;
import eu.cqse.check.util.clang.ClangUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SequencedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class CheckLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Class<?> checkClass;

    private CheckLoader(Class<?> checkClass) {
        CCSMAssert.isNotNull(checkClass);
        this.checkClass = checkClass;
    }

    private CheckInfo load() throws CheckException {
        Check checkAnnotation = this.checkClass.getAnnotation(Check.class);
        if (checkAnnotation == null) {
            return null;
        }
        if (!CheckLoader.languagesSupportParameters(checkAnnotation.languages(), checkAnnotation.parameters())) {
            throw new CheckException("Unsupported parameters!");
        }
        CheckMapping ruleEnablementItem = CheckMappingUtils.loadRuleEnablementForClass(this.checkClass, checkAnnotation);
        if (ruleEnablementItem.defaultEnablement == null) {
            return null;
        }
        String checkDescription = CheckLoader.loadCheckDescription(this.checkClass, checkAnnotation);
        CheckImplementationBase dummyInstance = CheckImplementationBase.createInstance(this.checkClass);
        return new CheckInfo(this.checkClass, ruleEnablementItem.checkId, ruleEnablementItem.getReadableCheckName(), checkDescription, ruleEnablementItem.group, ruleEnablementItem.category, ruleEnablementItem.defaultEnablement, checkAnnotation.languages(), checkAnnotation.parameters(), checkAnnotation.target(), checkAnnotation.phases(), CheckLoader.loadOptions(ruleEnablementItem, dummyInstance));
    }

    private static boolean languagesSupportParameters(ELanguage[] languages, ECheckParameter[] parameters) {
        for (ECheckParameter parameter : parameters) {
            if (parameter == ECheckParameter.CLANG) {
                if (!CollectionUtils.intersectionSet(ClangUtils.CLANG_ENABLED_LANGUAGES, (Collection[])new Collection[]{Arrays.asList(languages)}).isEmpty()) continue;
                return false;
            }
            for (ELanguage language : languages) {
                if (CheckLoader.languageSupportParameter(language, parameter)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean languageSupportParameter(ELanguage language, ECheckParameter parameter) {
        if (parameter == ECheckParameter.ABSTRACT_SYNTAX_TREE) {
            return ShallowParserFactory.supportsLanguage(language);
        }
        if (parameter == ECheckParameter.TYPE_RESOLUTION) {
            return TypeTrackerFactory.supportsLanguage(language);
        }
        return false;
    }

    private static SequencedMap<String, ICheckOption<?>> loadOptions(CheckMapping checkMapping, CheckImplementationBase dummyInstance) throws CheckException {
        ArrayList options = new ArrayList();
        options.addAll(CheckLoader.getFieldBasedOptions(dummyInstance));
        options.addAll(CheckLoader.getAdditionalOptions(checkMapping, dummyInstance));
        LinkedHashMap result = new LinkedHashMap();
        for (ICheckOption iCheckOption : options) {
            if (result.put(iCheckOption.getName(), iCheckOption) == null) continue;
            throw new CheckException("Check " + dummyInstance.getClass().getName() + " has duplicated option: " + iCheckOption.getName());
        }
        return result;
    }

    private static List<ICheckOption<?>> getFieldBasedOptions(CheckImplementationBase dummyInstance) throws CheckException {
        ArrayList options = new ArrayList();
        for (Field attribute : ReflectionUtils.getAllFields(dummyInstance.getClass())) {
            ICheckOption<?> option = CheckLoader.getOptionFromField(attribute, dummyInstance);
            if (option == null) continue;
            options.add(option);
        }
        return options;
    }

    private static List<ICheckOption<?>> getAdditionalOptions(CheckMapping checkMapping, CheckImplementationBase dummyInstance) {
        return dummyInstance.getAdditionalOptions(checkMapping.getReadableCheckName());
    }

    private static String loadCheckDescription(Class<?> checkClass, Check checkAnnotation) {
        boolean isInternalCheck = CheckMappingUtils.checkShouldHaveEntryInCheckMappings(checkClass);
        return CheckLoader.loadCheckDescription(checkClass, checkAnnotation, CheckLoader.getCheckDescriptionFilename(checkAnnotation, isInternalCheck), isInternalCheck);
    }

    private static String getCheckDescriptionFilename(Check checkAnnotation, boolean isInternalCheck) {
        String filename = isInternalCheck ? FileSystemUtils.toValidFileName((String)checkAnnotation.id()) : FileSystemUtils.toValidFileName((String)checkAnnotation.name());
        return filename + ".md";
    }

    private static String loadCheckDescription(Class<?> checkClass, Check checkAnnotation, String fileName, boolean isInternalCheck) {
        String descriptionFromFile = CheckDescriptionLoader.getCheckDescription(checkClass, fileName).orElse(null);
        String descriptionFromAnnotation = checkAnnotation.description();
        if (!StringUtils.isEmpty((String)descriptionFromFile)) {
            if (!StringUtils.isEmpty((String)descriptionFromAnnotation)) {
                LOGGER.warn("Check has both a description in the annotation and in the Markdown file " + fileName + ". The description from the annotation will be overwritten, so you may want to remove it.");
            }
            return descriptionFromFile;
        }
        if (isInternalCheck) {
            LOGGER.warn("Internal checks should have their descriptions in separate Markdown files. No description file found with the name " + fileName + ".");
        }
        return descriptionFromAnnotation;
    }

    private static ICheckOption<?> getOptionFromField(Field field, CheckImplementationBase dummyInstance) throws CheckException {
        field.setAccessible(true);
        CheckOption annotation = field.getAnnotation(CheckOption.class);
        if (annotation == null) {
            return null;
        }
        try {
            Object defaultValue = field.get(dummyInstance);
            if (defaultValue == null) {
                throw new CheckException("Check " + dummyInstance.getClass().getName() + " must have default values for options.");
            }
            Class type = field.getType();
            if (type.isPrimitive()) {
                type = ReflectionUtils.resolvePrimitiveClass(type);
            }
            FieldAnnotationBasedCheckOption<Object> option = new FieldAnnotationBasedCheckOption<Object>(annotation, field, defaultValue, type);
            return option;
        }
        catch (IllegalAccessException e) {
            CCSMAssert.fail((String)("Could not access default value: " + e.getMessage()));
            return null;
        }
    }

    public static CheckInfo loadFromClass(Class<?> checkClass) throws CheckException {
        return new CheckLoader(checkClass).load();
    }
}

