/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift.platformconditions;

import eu.cqse.check.framework.preprocessor.swift.platformconditions.ParseException;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionBase;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionParseResult;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.VersionPlatformCondition;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.string.StringUtils;

public class StringLiteralVersionPlatformCondition
extends VersionPlatformCondition {
    private static final TokenPattern VALUE_PARSE_PATTERN = new TokenPattern().sequence(ETokenType.LPAREN).sequence(ETokenType.STRING_LITERAL).group(0).sequence(ETokenType.RPAREN);

    public StringLiteralVersionPlatformCondition(@NonNull String name) {
        super(name);
    }

    @Override
    public @NonNull StringLiteralVersionPlatformCondition copyWithName(@NonNull String newName) {
        return new StringLiteralVersionPlatformCondition(newName);
    }

    @Override
    public @NonNull PlatformConditionParseResult parse(@NonNull TokenStream tokenStream) throws ParseException {
        PlatformConditionBase.GenericParseResult genericParseResult = this.parseGeneric(tokenStream);
        TokenPatternMatch valueMatch = VALUE_PARSE_PATTERN.matchFully(genericParseResult.valueTokens());
        if (valueMatch != null && valueMatch.hasGroup(0)) {
            IToken nameToken = tokenStream.peekCurrent();
            String versionString = StringUtils.removeDoubleQuotes((String)valueMatch.groupTokens(0).get(0).getText());
            throw new ParseException("String-literal-style version scheme for '%s' is not supported. Encountered value '%s' at '%s:%d'. Please migrate to the new version scheme.".formatted(nameToken.getText(), versionString, nameToken.getOriginId(), nameToken.getLineNumber()));
        }
        return super.parse(tokenStream);
    }

    @Override
    public String toString() {
        return "StringLiteralVersionPlatformCondition{name='" + this.name + "'}";
    }
}

