/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift.platformconditions;

import eu.cqse.check.framework.preprocessor.swift.platformconditions.IEvaluableConditionValue;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.ParseException;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionBase;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionParseResult;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStream;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.string.StringUtils;

class StringPlatformCondition
extends PlatformConditionBase {
    private static final TokenPattern VALUE_PARSE_PATTERN = new TokenPattern().sequence(ETokenType.LPAREN).alternative(ETokenType.IDENTIFIER, ETokenType.NONE).group(0).sequence(ETokenType.RPAREN);

    public StringPlatformCondition(@NonNull String name) {
        super(name);
    }

    @Override
    public @NonNull StringPlatformCondition copyWithName(@NonNull String newName) {
        return new StringPlatformCondition(newName);
    }

    protected @NonNull StringParseResult parseAsStringValue(@NonNull TokenStream tokenStream) throws ParseException {
        PlatformConditionBase.GenericParseResult genericParseResult = this.parseGeneric(tokenStream);
        TokenPatternMatch valueMatch = VALUE_PARSE_PATTERN.matchFully(genericParseResult.valueTokens());
        StringPlatformCondition.verifyMatch(tokenStream, valueMatch, 0);
        IToken valueToken = valueMatch.groupTokens(0).get(0);
        return new StringParseResult(genericParseResult.tokenCount(), valueToken);
    }

    @Override
    public @NonNull PlatformConditionParseResult parse(@NonNull TokenStream tokenStream) throws ParseException {
        StringParseResult stringParseResult = this.parseAsStringValue(tokenStream);
        tokenStream.advancePosition(stringParseResult.tokenCount);
        return new PlatformConditionParseResult(this, new Value(stringParseResult.valueToken.getText()));
    }

    @Override
    public @NonNull Object parseConfig(@NonNull String configValue) throws ParseException {
        if (StringUtils.isEmpty((String)configValue)) {
            throw new ParseException("Empty configuration value");
        }
        return configValue;
    }

    @Override
    public String toString() {
        return "StringPlatformCondition{name='" + this.name + "'}";
    }

    protected record StringParseResult(int tokenCount, IToken valueToken) {
    }

    static class Value
    implements IEvaluableConditionValue {
        private final String value;

        protected Value(@NonNull String value) {
            this.value = value;
        }

        @Override
        public Optional<Boolean> evaluate(@NonNull Object configValue) {
            if (!(configValue instanceof String)) {
                return Optional.empty();
            }
            String strValue = (String)configValue;
            return Optional.of(this.value.equals(strValue));
        }

        public String toString() {
            return this.value;
        }
    }
}

