/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.scanner;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IStatementOracle;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.TokenListLookahead;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.ILookahead;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ShallowParserStatementOracle
implements IStatementOracle {
    private final Set<IToken> statementEndTokens = new IdentityHashSet();
    private boolean nextIsEndOfStatement = false;
    private final IStatementOracle innerOracle;

    public ShallowParserStatementOracle(List<ShallowEntity> entities, IStatementOracle innerOracle) {
        this.innerOracle = innerOracle;
        for (ShallowEntity entity : ShallowEntityTraversalUtils.listAllEntities(entities)) {
            UnmodifiableList tokens = entity.includedTokens();
            int last = tokens.size() - 1;
            if (!entity.getChildren().isEmpty()) {
                int firstChildStartIndex = ((ShallowEntity)entity.getChildren().get(0)).getStartTokenIndex();
                int tokensToFirstChild = firstChildStartIndex - entity.getStartTokenIndex() - 1;
                last = Math.min(tokensToFirstChild, last);
            }
            if (last >= 0 && this.isEndOfStatementToken((List<IToken>)tokens, last)) {
                --last;
            }
            if (last < 0) continue;
            this.statementEndTokens.add((IToken)tokens.get(last));
        }
    }

    private boolean isEndOfStatementToken(List<IToken> tokens, int index) {
        return this.innerOracle.isEndOfStatementTokenType(tokens.get(index).getType(), new TokenListLookahead(tokens, index));
    }

    @Override
    public <X extends Exception> boolean isEndOfStatementToken(ETokenType tokenType, ILookahead<IToken, X> lookahead) throws X {
        if (this.nextIsEndOfStatement) {
            this.nextIsEndOfStatement = false;
            return true;
        }
        if (this.statementEndTokens.contains(lookahead.lookahead(0))) {
            this.nextIsEndOfStatement = true;
        }
        return this.innerOracle.isEndOfStatementToken(tokenType, lookahead);
    }

    @Override
    public <X extends Exception> boolean isEndOfStatementTokenType(ETokenType tokenType, ILookahead<ETokenType, X> lookahead) {
        throw new UnsupportedOperationException("This method is not supported by this implementation");
    }
}

