/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.IShallowParser;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.languages.abap.AbapShallowParser;
import eu.cqse.check.framework.shallowparser.languages.abap_cds.AbapCdsShallowParser;
import eu.cqse.check.framework.shallowparser.languages.ada.AdaShallowParser;
import eu.cqse.check.framework.shallowparser.languages.cobol.CobolShallowParser;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParser;
import eu.cqse.check.framework.shallowparser.languages.cs.CsShallowParser;
import eu.cqse.check.framework.shallowparser.languages.dart.DartShallowParser;
import eu.cqse.check.framework.shallowparser.languages.delphi.DelphiShallowParser;
import eu.cqse.check.framework.shallowparser.languages.esql.EsqlShallowParser;
import eu.cqse.check.framework.shallowparser.languages.fortran.FortranShallowParser;
import eu.cqse.check.framework.shallowparser.languages.go.GoShallowParser;
import eu.cqse.check.framework.shallowparser.languages.gosu.GosuShallowParser;
import eu.cqse.check.framework.shallowparser.languages.groovy.GroovyShallowParser;
import eu.cqse.check.framework.shallowparser.languages.hanasqlscript.HanaSQLScriptShallowParser;
import eu.cqse.check.framework.shallowparser.languages.iec61131.Iec61131ShallowParser;
import eu.cqse.check.framework.shallowparser.languages.java.JavaShallowParser;
import eu.cqse.check.framework.shallowparser.languages.javascript.JavaScriptShallowParser;
import eu.cqse.check.framework.shallowparser.languages.kotlin.KotlinShallowParser;
import eu.cqse.check.framework.shallowparser.languages.line.LineShallowParser;
import eu.cqse.check.framework.shallowparser.languages.matlab.MatlabShallowParser;
import eu.cqse.check.framework.shallowparser.languages.objectivec.ObjectiveCShallowParser;
import eu.cqse.check.framework.shallowparser.languages.objectivecpp.ObjectiveCppShallowParser;
import eu.cqse.check.framework.shallowparser.languages.ocaml.OcamlShallowParser;
import eu.cqse.check.framework.shallowparser.languages.opencl.OpenCLShallowParser;
import eu.cqse.check.framework.shallowparser.languages.oscript.OScriptShallowParser;
import eu.cqse.check.framework.shallowparser.languages.php.PhpShallowParser;
import eu.cqse.check.framework.shallowparser.languages.plsql.PlsqlShallowParser;
import eu.cqse.check.framework.shallowparser.languages.powershell.PowershellShallowParser;
import eu.cqse.check.framework.shallowparser.languages.python.PythonShallowParser;
import eu.cqse.check.framework.shallowparser.languages.rust.RustShallowParser;
import eu.cqse.check.framework.shallowparser.languages.swift.SwiftShallowParser;
import eu.cqse.check.framework.shallowparser.languages.tsql.TsqlShallowParser;
import eu.cqse.check.framework.shallowparser.languages.visualbasic.VisualBasicShallowParser;
import eu.cqse.check.framework.shallowparser.languages.wia.WorkItemShallowParser;
import eu.cqse.check.framework.shallowparser.languages.xtend.XtendShallowParser;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class ShallowParserFactory {
    private static final Map<ELanguage, IShallowParser> PARSERS = new EnumMap<ELanguage, IShallowParser>(ELanguage.class);
    private static final Map<ELanguage, Supplier<IShallowParser>> PARSER_FACTORIES = new EnumMap<ELanguage, Supplier<IShallowParser>>(ELanguage.class);

    private static void register(ELanguage language, Supplier<IShallowParser> parserFactory) {
        PARSER_FACTORIES.put(language, parserFactory);
    }

    public static synchronized IShallowParser createParser(ELanguage language) throws ShallowParserException {
        if (!PARSERS.containsKey(language)) {
            Supplier<IShallowParser> factory = PARSER_FACTORIES.get(language);
            if (factory == null) {
                throw new ShallowParserException("Shallow parsing for language " + String.valueOf(language) + " not yet supported!");
            }
            PARSERS.put(language, factory.get());
        }
        return PARSERS.get(language);
    }

    public static boolean supportsLanguage(ELanguage language) {
        return PARSER_FACTORIES.containsKey(language);
    }

    public static Set<ELanguage> getSupportedLanguages() {
        return EnumSet.copyOf(PARSER_FACTORIES.keySet());
    }

    static {
        ShallowParserFactory.register(ELanguage.JAVA, JavaShallowParser::new);
        ShallowParserFactory.register(ELanguage.ADA, AdaShallowParser::new);
        ShallowParserFactory.register(ELanguage.CS, CsShallowParser::new);
        ShallowParserFactory.register(ELanguage.CPP, CppShallowParser::new);
        ShallowParserFactory.register(ELanguage.C, CppShallowParser::new);
        ShallowParserFactory.register(ELanguage.CPP_MS_CLI, CppShallowParser::new);
        ShallowParserFactory.register(ELanguage.PLSQL, PlsqlShallowParser::new);
        ShallowParserFactory.register(ELanguage.ABAP, AbapShallowParser::new);
        ShallowParserFactory.register(ELanguage.JAVASCRIPT, JavaScriptShallowParser::new);
        ShallowParserFactory.register(ELanguage.PYTHON, PythonShallowParser::new);
        ShallowParserFactory.register(ELanguage.DELPHI, DelphiShallowParser::new);
        ShallowParserFactory.register(ELanguage.MATLAB, MatlabShallowParser::new);
        ShallowParserFactory.register(ELanguage.FORTRAN, FortranShallowParser::new);
        ShallowParserFactory.register(ELanguage.IEC61131, Iec61131ShallowParser::new);
        ShallowParserFactory.register(ELanguage.XTEND, XtendShallowParser::new);
        ShallowParserFactory.register(ELanguage.OCAML, OcamlShallowParser::new);
        ShallowParserFactory.register(ELanguage.TSQL, TsqlShallowParser::new);
        ShallowParserFactory.register(ELanguage.GROOVY, GroovyShallowParser::new);
        ShallowParserFactory.register(ELanguage.PHP, PhpShallowParser::new);
        ShallowParserFactory.register(ELanguage.SQLSCRIPT, HanaSQLScriptShallowParser::new);
        ShallowParserFactory.register(ELanguage.OPEN_CL, OpenCLShallowParser::new);
        ShallowParserFactory.register(ELanguage.RUST, RustShallowParser::new);
        ShallowParserFactory.register(ELanguage.VB, VisualBasicShallowParser::new);
        ShallowParserFactory.register(ELanguage.SWIFT, SwiftShallowParser::new);
        ShallowParserFactory.register(ELanguage.GOSU, GosuShallowParser::new);
        ShallowParserFactory.register(ELanguage.OSCRIPT, OScriptShallowParser::new);
        ShallowParserFactory.register(ELanguage.COBOL, CobolShallowParser::new);
        ShallowParserFactory.register(ELanguage.KOTLIN, KotlinShallowParser::new);
        ShallowParserFactory.register(ELanguage.LINE, LineShallowParser::new);
        ShallowParserFactory.register(ELanguage.OBJECTIVE_C, ObjectiveCShallowParser::new);
        ShallowParserFactory.register(ELanguage.OBJECTIVE_CPP, ObjectiveCppShallowParser::new);
        ShallowParserFactory.register(ELanguage.GO, GoShallowParser::new);
        ShallowParserFactory.register(ELanguage.NL_REQUIREMENTS, WorkItemShallowParser::forRequirements);
        ShallowParserFactory.register(ELanguage.NL_ISSUES, WorkItemShallowParser::forIssues);
        ShallowParserFactory.register(ELanguage.NL_TESTS, WorkItemShallowParser::forTests);
        ShallowParserFactory.register(ELanguage.ABAP_CDS, AbapCdsShallowParser::new);
        ShallowParserFactory.register(ELanguage.POWERSHELL, PowershellShallowParser::new);
        ShallowParserFactory.register(ELanguage.ESQL, EsqlShallowParser::new);
        ShallowParserFactory.register(ELanguage.DART, DartShallowParser::new);
    }
}

