/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import java.util.List;

class OptionalNestedRecognizer<STATE extends Enum<STATE>>
extends RecognizerBase<STATE> {
    private final ETokenType open;
    private final ETokenType close;
    private final RecognizerBase<STATE> subRecognizer;

    public OptionalNestedRecognizer(ETokenType open, ETokenType close, RecognizerBase<STATE> subRecognizer) {
        this.open = open;
        this.close = close;
        this.subRecognizer = subRecognizer;
    }

    @Override
    protected int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
        if (startOffset >= tokens.size() || tokens.get(startOffset).getType() != this.open) {
            return startOffset;
        }
        int depth = 1;
        ++startOffset;
        while (startOffset < tokens.size() && depth > 0) {
            int next;
            if (this.subRecognizer != null && (next = this.subRecognizer.matches(parserState, tokens, startOffset)) != -1) {
                startOffset = next;
                continue;
            }
            if (tokens.get(startOffset).getType() == this.open) {
                ++depth;
            } else if (tokens.get(startOffset).getType() == this.close) {
                --depth;
            }
            ++startOffset;
        }
        if (depth > 0) {
            return -1;
        }
        return startOffset;
    }

    @Override
    protected String getRecognizerStringRepresentation() {
        return "optionalNested[" + String.valueOf(this.subRecognizer) + "]";
    }
}

