/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.dart;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.languages.base.CStyleShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import eu.cqse.check.framework.shallowparser.languages.dart.DartSubExpressionRecognizer;
import java.util.ArrayList;
import java.util.List;

public class DartShallowParser
extends CStyleShallowParserBase {
    private static final ITokenMatcher VALID_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.ASYNC, ETokenType.AWAIT, ETokenType.DYNAMIC, ETokenType.GET, ETokenType.LET, ETokenType.SET, ETokenType.VALUE, ETokenType.VAR, ETokenType.RECORD, ETokenType.FINAL, ETokenType.CONST, ETokenType.QUESTION, ETokenType.FACTORY, ETokenType.LATE, ETokenType.EXTERNAL});
    private static final ITokenMatcher PRIMITIVE_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VOID, ETokenType.BYTE, ETokenType.SHORT, ETokenType.INT, ETokenType.LONG, ETokenType.FLOAT, ETokenType.DOUBLE, ETokenType.CHAR, ETokenType.BOOL, ETokenType.STRING, ETokenType.OBJECT, ETokenType.SBYTE, ETokenType.USHORT, ETokenType.UINT, ETokenType.ULONG, ETokenType.NUM, ETokenType.NUMBER, ETokenType.FUNCTION});
    private static final ITokenMatcher ATTRIBUTE_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FINAL, ETokenType.STATIC, ETokenType.LATE}).or(new ITokenMatcher[]{PRIMITIVE_TYPES});

    @Override
    protected void createSimpleStatementRule() {
        super.createSimpleStatementRule();
    }

    @Override
    public List<ShallowEntity> parseTopLevelWithErrors(List<IToken> tokens) throws ShallowParserException {
        ArrayList<IToken> modifiedTokens = new ArrayList<IToken>(tokens);
        if (!tokens.isEmpty()) {
            modifiedTokens.add(TokenStreamUtils.createToken(tokens.getLast(), "", ETokenType.EOF));
        }
        return super.parseTopLevelWithErrors(modifiedTokens);
    }

    @Override
    protected void createMetaRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE}).markStart().sequence(new ITokenMatcher[]{ETokenType.LIBRARY}).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER}).markStart().skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "library", INameResolver.ofRange(0, -2)).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE}).markStart().sequence(new ITokenMatcher[]{ETokenType.PART, ETokenType.STRING_LITERAL}).markStart().skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "part", INameResolver.ofRange(0, -2)).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE}).markStart().sequence(new ITokenMatcher[]{ETokenType.PART, ETokenType.OF, ETokenType.IDENTIFIER}).markStart().skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "part_of", INameResolver.ofRange(0, -2)).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE}).sequence(new ITokenMatcher[]{ETokenType.IMPORT}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -2)).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.PRAGMA}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "annotation", "pragma").skipNested(ETokenType.LPAREN, ETokenType.RPAREN).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.OVERRIDE}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "annotation", "override").skipNested(ETokenType.LPAREN, ETokenType.RPAREN).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.AT, ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "annotation", INameResolver.ofRange(1, -1)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).endNode();
        super.createMetaRules();
    }

    @Override
    protected void createTypeRules() {
        this.createEnumTypeRule();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).markStart().sequence(new ITokenMatcher[]{ETokenType.EXTENSION, ETokenType.IDENTIFIER}).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.LBRACE})).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.TYPE, "extension", INameResolver.secondMatchedTokenText()).parseUntil(EGenericParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        super.createTypeRules();
    }

    private void createEnumTypeRule() {
        RecognizerBase typeNode = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_TYPE}).repeated(this.getTypeModifier()).sequence(new ITokenMatcher[]{ETokenType.ENUM, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.TYPE, "enum", INameResolver.previousTokenText());
        RecognizerBase<EGenericParserStates> inEnumRule = typeNode.skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_ENUM);
        inEnumRule.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).parseUntil(EGenericParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        inEnumRule.sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    @Override
    public ITokenMatcher getTypeKeywordsMatcher() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CLASS, ETokenType.INTERFACE, ETokenType.ENUM, ETokenType.STRUCT, ETokenType.MIXIN, ETokenType.TYPE, ETokenType.EXTENSION, ETokenType.SEALED});
    }

    @Override
    protected ITokenMatcher getTypeModifier() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PRIVATE, ETokenType.ABSTRACT, ETokenType.STATIC, ETokenType.FINAL, ETokenType.EXTENSION, ETokenType.BASE});
    }

    @Override
    protected void createBasicBlockRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.ON, ETokenType.IDENTIFIER, ETokenType.CATCH, ETokenType.LPAREN, ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.COMMA, ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.RPAREN, ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "catch").parseOnce(EGenericParserStates.IN_METHOD).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.SWITCH}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).notFollowedBySequence(ETokenType.CASE).createNode(EShallowEntityType.STATEMENT, "switch").parseUntil(EGenericParserStates.IN_SWITCH_EXPRESSION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.createBasicBlockRule(this.getBlockRuleStart(), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TRY, ETokenType.ON}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY, ETokenType.DYNAMIC, ETokenType.ON}), true, false, INameResolver.firstMatchedTokenText());
        super.createBasicBlockRules();
    }

    @Override
    protected ITokenMatcher getOptionalTokensBeforeBlockBraces() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.ON});
    }

    @Override
    protected void createClassElementsRules() {
        this.createFunctionClassRules();
        this.createInitializerListRules();
        this.createLocalMethodsRules();
        this.createAttributeRules();
        this.createEnumAttributeRules();
        this.createOperatorOverrideRules();
        this.createMemberMethodsRules();
    }

    private void createFunctionClassRules() {
        this.completeMethod("method", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM, EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).subRecognizer(this.createTypeRecogniser()).sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).subRecognizer(this.createMethodNameRecogniser()).peekAhead(ETokenType.EQ));
        this.completeMethod("method", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM, EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).subRecognizer(this.createMethodNameRecogniser()).peekAhead(ETokenType.EQ));
        this.completeMethod("method", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM, EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).optionalSubRecognizer(this.createTypeRecogniser()).sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.GET}).subRecognizer(this.createMethodNameRecogniser()).peekAhead(ETokenType.DOUBLE_ARROW));
        this.completeMethod("method", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM, EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.GET}).subRecognizer(this.createMethodNameRecogniser()).peekAhead(ETokenType.DOUBLE_ARROW));
    }

    private void createInitializerListRules() {
        ITokenMatcher validInitializerListTokens = ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.KEYWORD, ETokenType.ETokenClass.OPERATOR, ETokenType.ETokenClass.LITERAL, ETokenType.ETokenClass.IDENTIFIER}).or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.DOT, ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.NULL, ETokenType.DOUBLE_QUESTION, ETokenType.EQ, ETokenType.ARROW, ETokenType.CONST, ETokenType.LBRACK, ETokenType.RBRACK, ETokenType.ASSERT, ETokenType.LT, ETokenType.GT, ETokenType.SPREAD_OPERATOR})});
        RecognizerBase superCallAlternative = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM}).skipBefore(this.getIdentifierMatcher()).markStart().repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.COLON, ETokenType.SUPER, ETokenType.LPAREN}).createNode(EShallowEntityType.METHOD, "method", INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN);
        superCallAlternative.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        superCallAlternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM}).skipBefore(this.getIdentifierMatcher()).markStart().repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.COLON, ETokenType.SUPER, ETokenType.LPAREN}).createNode(EShallowEntityType.METHOD, "method", INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM}).skipBefore(this.getIdentifierMatcher()).markStart().repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.COLON}).skipWhile(validInitializerListTokens).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).notFollowedBySequence(ETokenType.SPREAD_OPERATOR).createNode(EShallowEntityType.METHOD, "method", INameResolver.firstMatchedTokenText()).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM}).skipBefore(this.getIdentifierMatcher()).markStart().repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.COLON}).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, List.of(ETokenType.LBRACE), List.of(ETokenType.RBRACE)).createNode(EShallowEntityType.METHOD, "method", INameResolver.firstMatchedTokenText()).endNode();
        this.completeMethod("method", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).skipBefore(this.getIdentifierMatcher()).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).sequence(new ITokenMatcher[]{ETokenType.COLON}).skipWhile(validInitializerListTokens));
    }

    private void createEnumAttributeRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_ENUM}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.COMMA}).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createLocalMethodsRules() {
        this.completeMethod("local method", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).subRecognizer(this.createTypeRecogniser()).subRecognizer(this.createMethodNameRecogniser()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.ASYNC}).peekAheadAnyOf(ETokenType.LBRACE, ETokenType.DOUBLE_ARROW));
        this.completeMethod("local method", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).subRecognizer(this.createMethodNameRecogniser()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.ASYNC}).peekAheadAnyOf(ETokenType.LBRACE, ETokenType.DOUBLE_ARROW));
    }

    private void createAttributeRules() {
        RecognizerBase attributeDeclarationAlternative = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).optional(ATTRIBUTE_TOKENS).skipNested(ETokenType.LT, ETokenType.GT).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        attributeDeclarationAlternative.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText()).endNode();
        attributeDeclarationAlternative.sequence(new ITokenMatcher[]{ETokenType.EQ}).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, ETokenType.LBRACE, ETokenType.RBRACE).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createOperatorOverrideRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM}).optional(this.getIdentifierMatcher()).sequence(new ITokenMatcher[]{ETokenType.OPERATOR}).skipAfter(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.METHOD, "operator").endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM}).optional(this.getIdentifierMatcher()).sequence(new ITokenMatcher[]{ETokenType.OPERATOR}).skipAfter(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "operator").parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM}).optional(this.getIdentifierMatcher()).sequence(new ITokenMatcher[]{ETokenType.OPERATOR}).skipAfter(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.METHOD, "operator").endNode();
    }

    private void createMemberMethodsRules() {
        this.completeMethod("method", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM, EGenericParserStates.TOP_LEVEL}).subRecognizer(this.createTypeRecogniser()).optional(new ITokenMatcher[]{ETokenType.SET}).subRecognizer(this.createMethodNameRecogniser()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).notFollowedBySequence(ETokenType.COLON));
        this.completeMethod("method", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM, EGenericParserStates.TOP_LEVEL}).subRecognizer(this.createMethodNameRecogniser()).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).notFollowedBySequence(ETokenType.COLON));
        this.completeMethod("method", this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_ENUM, EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.GET}).markStart().subRecognizer(this.createMethodNameRecogniser()).notFollowedBySequence(ETokenType.SEMICOLON));
    }

    private void completeMethod(String subtype, RecognizerBase<EGenericParserStates> start) {
        RecognizerBase<EGenericParserStates> alternative = start.skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.SEMICOLON, ETokenType.DOUBLE_ARROW, ETokenType.EQ}));
        alternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, subtype, INameResolver.firstMatchedTokenText()).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        alternative.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.METHOD, subtype, INameResolver.firstMatchedTokenText()).endNode();
        RecognizerBase<EGenericParserStates> lambdaAlternative = alternative.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}).createNode(EShallowEntityType.METHOD, subtype, INameResolver.firstMatchedTokenText());
        this.createMapInitializationRule(lambdaAlternative);
        lambdaAlternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        lambdaAlternative.parseOnce(EGenericParserStates.IN_METHOD).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "lambda").parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        RecognizerBase<EGenericParserStates> equalsAlternative = alternative.sequence(new ITokenMatcher[]{ETokenType.EQ}).createNode(EShallowEntityType.METHOD, subtype, INameResolver.firstMatchedTokenText());
        equalsAlternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        equalsAlternative.parseOnce(EGenericParserStates.IN_METHOD).endNode();
    }

    private void createMapInitializationRule(RecognizerBase<EGenericParserStates> alternative) {
        RecognizerBase singlePairRecogniser = this.createRecognizer(s -> s.sequence(new ITokenMatcher[]{ETokenType.STRING_LITERAL}).sequence(new ITokenMatcher[]{ETokenType.COLON}).skipBeforeWithNesting(ETokenType.COMMA.or(new ITokenMatcher[]{ETokenType.RBRACE}), List.of(ETokenType.LBRACE, ETokenType.LPAREN), List.of(ETokenType.RBRACE, ETokenType.RPAREN)).optional(new ITokenMatcher[]{ETokenType.COMMA}));
        alternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).subRecognizer(singlePairRecogniser).repeatedSubRecognizer(singlePairRecogniser).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    @Override
    public ITokenMatcher getIdentifierMatcher() {
        return VALID_IDENTIFIERS;
    }

    @Override
    protected ITokenMatcher getSimpleBlockKeywordsWithParentheses() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHILE, ETokenType.FOR, ETokenType.LOCK, ETokenType.SWITCH});
    }

    @Override
    public RecognizerBase<EGenericParserStates> typePattern(RecognizerBase<EGenericParserStates> currentState) {
        ITokenMatcher modifierKeywords = this.getTypeModifier().or(new ITokenMatcher[]{ETokenType.PROTECTED, ETokenType.ASYNC, ETokenType.CONST, ETokenType.EXTERN, ETokenType.OVERRIDE, ETokenType.NEW});
        ITokenMatcher typeStart = this.getIdentifierMatcher().or(new ITokenMatcher[]{PRIMITIVE_TYPES});
        RecognizerBase simpleTypeRecognizer = this.createRecognizer(start -> start.sequence(typeStart).repeated(new ITokenMatcher[]{ETokenType.DOT, typeStart}).skipNested(ETokenType.LT, ETokenType.GT).optionalSubRecognizer(this.createTypeSuffixRecognizer()));
        RecognizerBase tupleTypeRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).optionalSubRecognizer(this.createTypeSuffixRecognizer()));
        RecognizerBase typeRecognizer = this.createRecognizer(start -> start.subRecognizer(simpleTypeRecognizer));
        typeRecognizer.subRecognizer(tupleTypeRecognizer);
        return currentState.repeated(modifierKeywords).subRecognizer(typeRecognizer);
    }

    private RecognizerBase<EGenericParserStates> createTypeSuffixRecognizer() {
        RecognizerBase recognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.QUESTION}).optional(new ITokenMatcher[]{ETokenType.MULT}).skipNested(ETokenType.LBRACK, ETokenType.RBRACK));
        return this.createRecognizer(start -> start.skipNested(ETokenType.LT, ETokenType.GT).repeatedSubRecognizer(recognizer));
    }

    private RecognizerBase<EGenericParserStates> createTypeRecogniser() {
        return this.createRecognizer(this::typePattern);
    }

    private RecognizerBase<EGenericParserStates> createMethodNameRecogniser() {
        return this.createRecognizer(start -> start.markStart().sequence(this.getIdentifierMatcher().or(new ITokenMatcher[]{PRIMITIVE_TYPES})).skipNested(ETokenType.LT, ETokenType.GT));
    }

    @Override
    protected ITokenMatcher getSimpleBlockKeywordsWithoutParentheses() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.FINALLY});
    }

    @Override
    public ITokenMatcher getStatementStartTokens() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.NEW, ETokenType.BREAK, ETokenType.CONTINUE, ETokenType.RETURN, ETokenType.ASSERT, ETokenType.CONST, ETokenType.GOTO, ETokenType.THROW, ETokenType.THIS, ETokenType.CHECKED, ETokenType.SIZEOF, ETokenType.TYPEOF, ETokenType.VALUE, ETokenType.YIELD, ETokenType.LPAREN, ETokenType.PLUSPLUS, ETokenType.MINUSMINUS, ETokenType.NOT, ETokenType.PLUS, ETokenType.MINUS, ETokenType.COMP, ETokenType.TRUE, ETokenType.FALSE, ETokenType.BOOLEAN_LITERAL, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER, ETokenType.MULT, ETokenType.DEFAULT, ETokenType.SUPER, ETokenType.LBRACK, ETokenType.LBRACE, ETokenType.LT, ETokenType.RETHROW});
    }

    @Override
    protected RecognizerBase<EGenericParserStates> getBlockRuleStart() {
        return super.getBlockRuleStart().optional(new ITokenMatcher[]{ETokenType.AWAIT}).markStart();
    }

    @Override
    protected void createSubExpressionRules() {
        super.createSubExpressionRules();
        this.createSwitchExpressionRules();
        this.createLambdaWithArrowRules(ETokenType.DOUBLE_ARROW);
        this.createBasicBlockRule(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}), (ITokenMatcher)ETokenType.SWITCH, null, true, false, INameResolver.ofString("switch"));
    }

    @Override
    public RecognizerBase<EGenericParserStates> getSubExpressionRecognizer() {
        return new DartSubExpressionRecognizer();
    }

    private void createSwitchExpressionRules() {
        RecognizerBase isSwitchExpression = this.createRecognizer(start -> start.skipBeforeWithNesting((ITokenMatcher)ETokenType.DOUBLE_ARROW, List.of(ETokenType.LBRACE, ETokenType.LPAREN), List.of(ETokenType.LBRACE, ETokenType.LPAREN)).skipBeforeWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE));
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.SWITCH}).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).preCondition(isSwitchExpression).createNode(EShallowEntityType.STATEMENT, "switch expression", INameResolver.firstMatchedTokenText()).parseUntil(EGenericParserStates.IN_SWITCH_EXPRESSION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_SWITCH_EXPRESSION}).peekAhead(ETokenType.DOUBLE_ARROW).parseOnce(EGenericParserStates.IN_EXPRESSION).optional(new ITokenMatcher[]{ETokenType.COMMA});
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_SWITCH_EXPRESSION}).skipBefore(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}).createNode(EShallowEntityType.META, "case", INameResolver.ofRange(0, -1)).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_SWITCH_EXPRESSION}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}).createNode(EShallowEntityType.META, "case", INameResolver.firstMatchedTokenText()).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.BOOLEAN_LITERAL, ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.LT, ETokenType.GT, ETokenType.EQ, ETokenType.EQEQ, ETokenType.THROW, ETokenType.DOUBLE_ARROW, ETokenType.SPREAD_OPERATOR})).skipNested(ETokenType.LBRACE, ETokenType.RBRACE).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
    }

    @Override
    protected void createCaseRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).markStart().sequence(new ITokenMatcher[]{ETokenType.CASE}).skipAfterWithNesting(this.getCaseStatementEndTokens(), ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -2)).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DEFAULT, this.getCaseStatementEndTokens()}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
    }
}

