/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.typetracker.ITypeTracker;
import eu.cqse.check.framework.typetracker.abap.AbapTypeTracker;
import eu.cqse.check.framework.typetracker.cpp.CppTypeTracker;
import eu.cqse.check.framework.typetracker.cs.CsTypeTracker;
import eu.cqse.check.framework.typetracker.java.JavaTypeTracker;
import java.util.EnumMap;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;

public class TypeTrackerFactory {
    private static final UnmodifiableMap<ELanguage, Supplier<? extends ITypeTracker>> TYPE_TRACKERS = TypeTrackerFactory.getTypeTrackers();

    private static @NonNull UnmodifiableMap<ELanguage, Supplier<? extends ITypeTracker>> getTypeTrackers() {
        EnumMap<ELanguage, Supplier<ITypeTracker>> result = new EnumMap<ELanguage, Supplier<ITypeTracker>>(ELanguage.class);
        result.put(ELanguage.ABAP, AbapTypeTracker::new);
        result.put(ELanguage.CPP, CppTypeTracker::new);
        result.put(ELanguage.CPP_MS_CLI, CppTypeTracker::new);
        result.put(ELanguage.C, CppTypeTracker::new);
        result.put(ELanguage.CS, CsTypeTracker::new);
        result.put(ELanguage.JAVA, JavaTypeTracker::new);
        return CollectionUtils.asUnmodifiable(result);
    }

    public static ITypeTracker createTypeTracker(ELanguage language) {
        Supplier typeTrackerFactory = (Supplier)TYPE_TRACKERS.get((Object)language);
        CCSMAssert.isNotNull((Object)typeTrackerFactory, (String)("No type tracker is defined for " + language.getReadableName()));
        return (ITypeTracker)typeTrackerFactory.get();
    }

    public static boolean supportsLanguage(ELanguage language) {
        return TYPE_TRACKERS.containsKey((Object)language);
    }
}

