/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.JavaAnalysisUtils;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;

public class JavaExpressionTypeExtractor {
    private static final TokenPattern ARRAY_CREATION_PATTERN = TokenPattern.of().sequence(ETokenType.NEW).alternative(ETokenType.IDENTIFIER, ETokenType.FLOAT, ETokenType.BYTE, ETokenType.SHORT, ETokenType.INT, ETokenType.LONG, ETokenType.DOUBLE).repeated(ETokenType.DOT, ETokenType.IDENTIFIER).skipNested(ETokenType.LBRACK, ETokenType.RBRACK, true).optional(TokenPattern.of().optional(TokenPattern.of().skipNested(ETokenType.LBRACE, ETokenType.RBRACE, false))).optional(ETokenType.SEMICOLON).endOfStream();
    private static final TokenPattern CONSTRUCTOR_PATTERN = TokenPattern.of().skipNested(ETokenType.LPAREN, ETokenType.RPAREN, true).sequence(ETokenType.NEW).sequence(ETokenType.IDENTIFIER).group(0).repeated(ETokenType.DOT, ETokenType.IDENTIFIER).group(1).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, false).endOfStream();

    public static Optional<InferTypeResult> inferExpressionResultType(ShallowEntity statement, List<IToken> tokens, ITypeResolution typeResolution, JavaImportSensitiveTypeResolver typeResolver) {
        if (tokens.isEmpty()) {
            return Optional.empty();
        }
        if (tokens.size() == 1) {
            return JavaExpressionTypeExtractor.inferSingleTokenType(statement, tokens.getFirst(), typeResolution, typeResolver);
        }
        Optional<String> instantiation = JavaExpressionTypeExtractor.getObjectOrArrayInstantiation(tokens);
        if (instantiation.isPresent()) {
            String typeName = instantiation.get();
            return Optional.of(new InferTypeResult(typeResolver.getFullyQualifiedTypeName(typeName), Collections.emptyList()));
        }
        Optional<String> knownReturnType = JavaExpressionTypeExtractor.getKnownBuildInMethodReturnType(tokens);
        if (knownReturnType.isPresent()) {
            return Optional.of(new InferTypeResult(knownReturnType.get(), Collections.emptyList()));
        }
        Optional surroundingType = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)statement, parent -> parent.getType() == EShallowEntityType.TYPE);
        if (surroundingType.isEmpty()) {
            return Optional.empty();
        }
        return JavaExpressionTypeExtractor.resolveMethodReturnType(statement, tokens, typeResolver, (ShallowEntity)surroundingType.get());
    }

    private static Optional<String> getObjectOrArrayInstantiation(List<IToken> tokens) {
        return JavaExpressionTypeExtractor.getObjectInstantiation(tokens).or(() -> JavaExpressionTypeExtractor.getArrayCreation(tokens));
    }

    private static Optional<String> getObjectInstantiation(List<IToken> tokens) {
        TokenPatternMatch constructorMatch = CONSTRUCTOR_PATTERN.findFirstMatch(tokens);
        if (constructorMatch == null) {
            return Optional.empty();
        }
        if (constructorMatch.hasGroup(1)) {
            return Optional.of(TokenStreamTextUtils.concatTokenTexts(constructorMatch.tokensBetweenGroupsExclusive(0, 1)));
        }
        return Optional.ofNullable(constructorMatch.groupTokens(0).getFirst().getText());
    }

    private static Optional<InferTypeResult> resolveMethodReturnType(ShallowEntity statement, List<IToken> tokens, JavaImportSensitiveTypeResolver typeResolver, ShallowEntity surroundingType) {
        TokenPattern methodCallPattern = TokenPattern.of().optional(TokenPattern.of().alternative(TokenPattern.of().sequence(ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{surroundingType.getName()})})), TokenPattern.of().sequence(ETokenType.THIS)).sequence(ETokenType.DOT)).sequence(ETokenType.IDENTIFIER).group(0).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, false).group(1);
        TokenPatternMatch matchAtStart = methodCallPattern.matchAtStartOf(tokens);
        if (matchAtStart == null) {
            return Optional.empty();
        }
        IToken callToken = matchAtStart.groupTokens(0).getFirst();
        String methodName = callToken.getText();
        ListMap<String, ShallowEntity> methodsDeclarationsOfSurroundingType = JavaExpressionTypeExtractor.getMethodsDeclarationsOfSurroundingType(statement);
        List<ShallowEntity> methodCandidates = (List<ShallowEntity>)methodsDeclarationsOfSurroundingType.getCollectionOrEmpty((Object)methodName);
        if (methodCandidates.isEmpty()) {
            return Optional.empty();
        }
        int expectedArgumentCount = JavaLanguageFeatureParser.getMethodArguments(statement, callToken.getOffset()).size();
        if ((methodCandidates = methodCandidates.stream().filter(method -> CLikeLanguageFeatureParserBase.getMethodArguments(method).size() == expectedArgumentCount).toList()).isEmpty()) {
            return Optional.empty();
        }
        if (methodCandidates.stream().map(LanguageFeatureParser.JAVA::getReturnType).distinct().count() == 1L) {
            String returnType = LanguageFeatureParser.JAVA.getReturnType(methodCandidates.getFirst());
            if (returnType == null) {
                return Optional.empty();
            }
            IToken closingBraceToken = matchAtStart.groupTokens(1).getLast();
            List<IToken> afterClosingBraceTokens = tokens.stream().filter(token -> token.getOffset() > closingBraceToken.getOffset()).toList();
            return Optional.of(new InferTypeResult(typeResolver.getFullyQualifiedTypeName(returnType), afterClosingBraceTokens));
        }
        return Optional.empty();
    }

    private static Optional<String> getKnownBuildInMethodReturnType(List<IToken> tokens) {
        String tokenText = TokenStreamTextUtils.concatTokenTexts(tokens);
        if (tokenText.endsWith(".toString()")) {
            return Optional.of("String");
        }
        if (tokenText.endsWith(".hashCode()")) {
            return Optional.of("int");
        }
        if (StringUtils.endsWithOneOf((String)tokenText, (String[])new String[]{".getClass()", ".clone()"})) {
            return Optional.of("Object");
        }
        return Optional.empty();
    }

    static Optional<String> getArrayCreation(List<IToken> tokens) {
        TokenPatternMatch match = ARRAY_CREATION_PATTERN.matchFully(tokens);
        if (match == null) {
            return Optional.empty();
        }
        List<IToken> creatorTokens = tokens.stream().filter(token -> token.getType() != ETokenType.NEW).takeWhile(token -> token.getType() != ETokenType.LBRACK).toList();
        return Optional.of(TokenStreamTextUtils.concatTokenTexts(creatorTokens) + "[]");
    }

    private static Optional<InferTypeResult> inferSingleTokenType(ShallowEntity statement, IToken token, ITypeResolution typeResolution, JavaImportSensitiveTypeResolver typeResolver) {
        if (token.getType().isIdentifier()) {
            TypedVariable typeInfo = typeResolution.getTypeLookup(statement).getTypeInfo(token.getText());
            if (typeInfo == null) {
                return Optional.empty();
            }
            String typeName = typeInfo.getTypeName();
            return Optional.of(new InferTypeResult(typeResolver.getFullyQualifiedTypeName(typeName), Collections.emptyList()));
        }
        if (token.getType().isLiteral()) {
            return Optional.of(new InferTypeResult(JavaExpressionTypeExtractor.resolveLiteralType(token), Collections.emptyList()));
        }
        return Optional.empty();
    }

    private static String resolveLiteralType(IToken token) {
        return switch (token.getType()) {
            case ETokenType.INTEGER_LITERAL -> "int";
            case ETokenType.BOOLEAN_LITERAL -> "boolean";
            case ETokenType.BACKTICK_STRING_LITERAL, ETokenType.STRING_LITERAL, ETokenType.UNTERMINATED_STRING_LITERAL -> "String";
            case ETokenType.FLOATING_POINT_LITERAL -> "float";
            case ETokenType.CHARACTER_LITERAL -> "char";
            case ETokenType.NULL_LITERAL -> "null";
            default -> token.getText();
        };
    }

    private static ListMap<String, ShallowEntity> getMethodsDeclarationsOfSurroundingType(ShallowEntity entity) {
        Optional surroundingType = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, parent -> parent.getType() == EShallowEntityType.TYPE);
        if (surroundingType.isEmpty()) {
            return ListMap.emptyMap();
        }
        List methods = ShallowEntityTraversalUtils.listMethodsNonRecursive(List.of((ShallowEntity)surroundingType.get()));
        ListMap methodsDeclarationsOfSurroundingType = new ListMap();
        for (ShallowEntity attribute : methods) {
            methodsDeclarationsOfSurroundingType.add((Object)attribute.getName(), (Object)attribute);
        }
        return methodsDeclarationsOfSurroundingType;
    }

    public record InferTypeResult(String inferredType, List<IToken> remainingTokensToRight) {
        private static final Pattern LITERAL_TOKEN_PATTERN = Pattern.compile("^(true)|(false)|('\\\\?.')|(\".*\")|(-?((\\d+\\.\\d*)|(\\d*\\.\\d+))(e-?\\d+)?[fFdD]?)|(-?((\\d+)|(0x[0-9a-fA-F]+)|(0b[01]+))[lL]?)$");
        private static final Set<String> NUMBER_TYPES = Set.of("long", "Long", "int", "Integer", "double", "Double", "float", "Float", "short", "Short", "BigInteger", "BigDecimal", "byte", "Byte");
        private static final Set<String> PRIMITIVES = Set.of("int", "long", "short", "byte", "float", "double", "boolean", "char");

        public InferTypeResult getKnownBaseType() {
            if (JavaAnalysisUtils.COMMON_MAP_IMPLEMENTATIONS.contains(this.inferredType())) {
                return new InferTypeResult("java.util.Map", this.remainingTokensToRight());
            }
            if (JavaAnalysisUtils.COMMON_COLLECTION_IMPLEMENTATIONS.contains(this.inferredType())) {
                return new InferTypeResult("java.util.Collection", this.remainingTokensToRight());
            }
            if (NUMBER_TYPES.contains(this.inferredType())) {
                return new InferTypeResult("Number", this.remainingTokensToRight());
            }
            if (this.inferredType().endsWith("[]")) {
                return new InferTypeResult("Array", this.remainingTokensToRight());
            }
            return this;
        }

        public boolean isLiteral() {
            return this.remainingTokensToRight.isEmpty() && LITERAL_TOKEN_PATTERN.matcher(this.inferredType).matches();
        }

        public boolean canBeNull() {
            return !this.isPrimitive() && !this.isLiteral();
        }

        public boolean isNull() {
            return this.remainingTokensToRight.isEmpty() && this.inferredType.equals("null");
        }

        public boolean isPrimitive() {
            return this.remainingTokensToRight.isEmpty() && this.isPrimitiveString(this.inferredType);
        }

        private boolean isPrimitiveString(String typeAsString) {
            return PRIMITIVES.contains(typeAsString);
        }

        public boolean isString() {
            return this.inferredType.equals("String") && this.remainingTokensToRight.isEmpty();
        }

        public boolean isArray() {
            return this.remainingTokensToRight.isEmpty() && (this.getKnownBaseType().inferredType.equals("Array") || this.isPrimitiveArray());
        }

        public boolean isPrimitiveArray() {
            return this.remainingTokensToRight.isEmpty() && this.getKnownBaseType().inferredType.equals("Array") && this.isPrimitiveString(StringUtils.stripSuffix((String)this.inferredType, (String)"[]"));
        }

        public boolean isArrayOrList() {
            return this.remainingTokensToRight.isEmpty() && (this.getKnownBaseType().inferredType.equals("Array") || this.getKnownBaseType().inferredType.equals("java.util.List"));
        }

        public Boolean isDate() {
            return this.remainingTokensToRight.isEmpty() && this.inferredType.equals("java.util.Date");
        }
    }
}

