/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.abap;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.util.CheckUtils;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class FunctionCallInfo {
    public static final int NAME_START_TOKEN = 2;
    private static final String OTHERS = "OTHERS";
    public static final ITokenMatcher PARAMETER_SECTION_DELIMITERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXPORTING, ETokenType.IMPORTING, ETokenType.TABLES, ETokenType.CHANGING, ETokenType.EXCEPTIONS, ETokenType.PARAMETER_TABLE, ETokenType.EXCEPTION_TABLE, ETokenType.DOT});
    private static final List<ETokenType> CLOSING_TOKENS = Collections.singletonList(ETokenType.RPAREN);
    private static final List<ETokenType> OPENING_TOKENS = Collections.singletonList(ETokenType.LPAREN);
    private static final int UNSPECIFIED_ERROR_CODE = -1;
    private final String functionName;
    private final Map<String, List<IToken>> exportingParameters = new TreeMap<String, List<IToken>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Integer> exceptionsSpecifiction = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
    private final List<IToken> tokens;

    public FunctionCallInfo(List<IToken> tokens) throws CheckException {
        this.tokens = tokens;
        this.functionName = this.parseFunctionName();
        this.parseExportingParameters();
        this.parseExceptions();
    }

    private String parseFunctionName() {
        int endOfName = TokenStreamUtils.firstTokenMatching(this.tokens, PARAMETER_SECTION_DELIMITERS);
        List<IToken> calledFunctionTokens = this.tokens.subList(2, endOfName);
        if (FunctionCallInfo.isStaticFunctionCall(calledFunctionTokens)) {
            return CheckUtils.getUnquotedTextForCharacterLiteral(calledFunctionTokens.getFirst());
        }
        return TokenStreamTextUtils.concatTokenTexts(calledFunctionTokens);
    }

    private static boolean isStaticFunctionCall(List<IToken> functionNameTokens) {
        return functionNameTokens.size() == 1 && functionNameTokens.getFirst().getType() == ETokenType.CHARACTER_LITERAL;
    }

    private void parseExportingParameters() throws CheckException {
        List<IToken> exportingSectionTokens = this.getParameterSectionTokens(ETokenType.EXPORTING);
        if (exportingSectionTokens.isEmpty()) {
            return;
        }
        if (exportingSectionTokens.size() < 2) {
            throw new CheckException("Unable to parse CALL FUNCTION: EXPORTING section of " + this.functionName + " does not start with 'param ='. (line " + this.tokens.getFirst().getLineNumber() + ")");
        }
        int parameterStart = 0;
        while (parameterStart != -1) {
            int nextEq = TokenStreamUtils.findFirstTopLevel(exportingSectionTokens, parameterStart, (ITokenMatcher)ETokenType.EQ, OPENING_TOKENS, CLOSING_TOKENS);
            if (nextEq == -1) {
                return;
            }
            String formalParameterText = TokenStreamTextUtils.concatTokenTexts(exportingSectionTokens.subList(parameterStart, nextEq));
            int actualStart = nextEq + 1;
            int nextParameterStart = FunctionCallInfo.indexOfNextTokenAfterWhitespace(exportingSectionTokens, actualStart, OPENING_TOKENS, CLOSING_TOKENS);
            int actualEnd = nextParameterStart == -1 ? exportingSectionTokens.size() : nextParameterStart;
            this.exportingParameters.put(formalParameterText, exportingSectionTokens.subList(actualStart, actualEnd));
            parameterStart = nextParameterStart;
        }
    }

    @VisibleForTesting
    static int indexOfNextTokenAfterWhitespace(List<IToken> tokens, int startIndex, List<ETokenType> openTypes, List<ETokenType> closingTypes) {
        return TokenStreamUtils.findFirstTopLevelWithIndexPredicate(tokens, startIndex + 1, index -> {
            if (index < 1) {
                return false;
            }
            int previousEndOffset = ((IToken)tokens.get(index - 1)).getEndOffset();
            return previousEndOffset + 1 < ((IToken)tokens.get((int)index)).getOffset();
        }, openTypes, closingTypes);
    }

    private void parseExceptions() throws CheckException {
        List<IToken> sectionTokens = this.getParameterSectionTokens(ETokenType.EXCEPTIONS);
        int currentIndex = 0;
        while (currentIndex < sectionTokens.size()) {
            String exceptionName = sectionTokens.get(currentIndex).getText();
            if (currentIndex + 1 == sectionTokens.size() || sectionTokens.get(currentIndex + 1).getType() != ETokenType.EQ) {
                this.exceptionsSpecifiction.put(exceptionName, -1);
                ++currentIndex;
                continue;
            }
            IToken errorCodeToken = sectionTokens.get(currentIndex += 2);
            Integer returnCode = FunctionCallInfo.extractExceptionReturnCode(errorCodeToken);
            if (returnCode == null) {
                throw new CheckException(String.valueOf(errorCodeToken.getType()) + " detected but integer literal or identifier expected as exception code for " + exceptionName);
            }
            this.exceptionsSpecifiction.put(exceptionName, returnCode);
            ++currentIndex;
        }
    }

    private List<IToken> getParameterSectionTokens(ETokenType sectionType) throws CheckException {
        int sectionEnd;
        int sectionStart = TokenStreamUtils.findFirstTopLevel(this.tokens, (ITokenMatcher)sectionType, OPENING_TOKENS, CLOSING_TOKENS);
        while (sectionStart > 1 && (this.tokens.get(sectionStart - 1).getType() == ETokenType.EXCEPTION_TABLE || this.tokens.get(sectionStart - 1).getType() == ETokenType.PARAMETER_TABLE)) {
            sectionStart = TokenStreamUtils.findFirstTopLevel(this.tokens, sectionStart + 1, (ITokenMatcher)sectionType, OPENING_TOKENS, CLOSING_TOKENS);
        }
        if (sectionStart == -1) {
            return Collections.emptyList();
        }
        if ((sectionEnd = TokenStreamUtils.findFirstTopLevel(this.tokens, ++sectionStart + 1, PARAMETER_SECTION_DELIMITERS, OPENING_TOKENS, CLOSING_TOKENS)) == -1) {
            throw new CheckException("Unable to parse CALL FUNCTION: end token for EXPORTING section not found.");
        }
        return this.tokens.subList(sectionStart, sectionEnd);
    }

    private static Integer extractExceptionReturnCode(IToken errorCodeToken) {
        String errorCode;
        if (errorCodeToken.getType() == ETokenType.INTEGER_LITERAL) {
            return Integer.valueOf(errorCodeToken.getText());
        }
        if (LanguageFeatureParser.ABAP.isPossiblyIdentifier(errorCodeToken)) {
            return -1;
        }
        if ((errorCodeToken.getType() == ETokenType.CHARACTER_LITERAL || errorCodeToken.getType() == ETokenType.STRING_LITERAL) && StringUtils.isInteger((String)(errorCode = StringUtils.removeAll((String)errorCodeToken.getText(), (String[])new String[]{"|", "`", "'"})))) {
            return Integer.valueOf(errorCode);
        }
        return null;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Optional<IToken> getPassedExportingToken(String formalParamterName) {
        List<IToken> passed = this.exportingParameters.get(formalParamterName);
        if (passed == null || passed.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(passed.getFirst());
    }

    public boolean isSettingErrorCodeForException(String exceptionName) {
        Integer errorCode = this.exceptionsSpecifiction.get(exceptionName);
        if (errorCode == null) {
            if (OTHERS.equals(exceptionName)) {
                return false;
            }
            return this.isSettingErrorCodeForException(OTHERS);
        }
        return errorCode != 0;
    }
}

