/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public abstract class CollectionMap<K, V, C extends Collection<V>>
implements Serializable,
Iterable<Map.Entry<K, C>> {
    private static final long serialVersionUID = 1L;
    private final Map<K, C> map = this.createUnderlyingMap();

    protected Map<K, C> createUnderlyingMap() {
        return new HashMap();
    }

    protected abstract C createNewCollection();

    public @Nullable C getCollection(K key) {
        return (C)((Collection)this.map.get(key));
    }

    public C getCollectionOrElse(K key, C defaultCollection) {
        if (this.map.containsKey(key)) {
            return (C)((Collection)this.map.get(key));
        }
        return defaultCollection;
    }

    public C getCollectionOrEmpty(K key) {
        C result = this.getCollection(key);
        if (result == null) {
            return this.createNewCollection();
        }
        return result;
    }

    public boolean add(K key, V value) {
        return this.getOrCreateCollection(key).add(value);
    }

    public boolean addAll(K key, Collection<? extends V> values) {
        return this.getOrCreateCollection(key).addAll(values);
    }

    C getOrCreateCollection(K key) {
        Collection<Object> collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = this.createNewCollection();
            this.map.put(key, collection);
        }
        return (C)collection;
    }

    public void addAll(CollectionMap<K, V, C> other) {
        for (Object key : other.getKeys()) {
            C collection = other.getCollection(key);
            if (collection == null) continue;
            this.addAll((K)key, (Collection<? extends V>)collection);
        }
    }

    public void addAll(Map<K, C> other) {
        for (Map.Entry<K, C> entry : other.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            if (collection == null) continue;
            this.addAll(entry.getKey(), collection);
        }
    }

    public boolean contains(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            return false;
        }
        return collection.contains(value);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean remove(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            return false;
        }
        return collection.remove(value);
    }

    public boolean containsCollection(K key) {
        return this.map.containsKey(key);
    }

    public boolean removeCollection(K key) {
        return this.map.remove(key) != null;
    }

    public UnmodifiableSet<K> getKeys() {
        return CollectionUtils.asUnmodifiable(this.map.keySet());
    }

    public C getValues() {
        C result = this.createNewCollection();
        for (Collection values : this.map.values()) {
            result.addAll(values);
        }
        return result;
    }

    public void removeIf(Predicate<? super V> filter) {
        for (Collection collection : this.map.values()) {
            collection.removeIf(filter);
        }
    }

    public Set<Map.Entry<K, C>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public int getValueCount() {
        int result = 0;
        for (Collection values : this.map.values()) {
            result += values.size();
        }
        return result;
    }

    public void clear() {
        this.map.clear();
    }

    public Map<K, V[]> collectionsToArrays(Class<V> type) {
        HashMap map = new HashMap();
        for (Object key : this.getKeys()) {
            map.put(key, CollectionUtils.toArray((Collection)Objects.requireNonNull(this.getCollection(key)), type));
        }
        return map;
    }

    public Map<K, C> getRaw() {
        return this.map;
    }

    public boolean equals(Object other) {
        if (other instanceof CollectionMap) {
            return this.map.equals(((CollectionMap)other).map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public @NonNull Iterator<Map.Entry<K, C>> iterator() {
        return this.map.entrySet().iterator();
    }

    public static <K, V, C extends Collection<V>> CollectionMap<K, V, C> createWithCollectionSupplier(final Supplier<C> collectionInitializer) {
        return new CollectionMap<K, V, C>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected C createNewCollection() {
                return (Collection)collectionInitializer.get();
            }
        };
    }
}

