/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.UnmodifiableListImpl;
import org.conqat.lib.commons.collections.UnmodifiableListIterator;
import org.conqat.lib.commons.collections.UnmodifiableRandomAccessListImpl;
import org.conqat.lib.commons.collections.UnmodifiableSequencedCollection;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public sealed interface UnmodifiableList<E>
extends List<E>,
UnmodifiableSequencedCollection<E>
permits UnmodifiableListImpl {
    public static <E> UnmodifiableList<E> of(List<E> list) {
        if (list instanceof UnmodifiableList) {
            UnmodifiableList unmodifiable = (UnmodifiableList)list;
            return unmodifiable;
        }
        if (list instanceof RandomAccess) {
            return new UnmodifiableRandomAccessListImpl<E>(list);
        }
        return new UnmodifiableListImpl<E>(list);
    }

    @Override
    public UnmodifiableList<E> reversed();

    @Override
    public @NonNull UnmodifiableListIterator<E> listIterator();

    @Override
    public @NonNull UnmodifiableListIterator<E> listIterator(int var1);

    @Override
    public @NonNull UnmodifiableList<E> subList(int var1, int var2);

    @Override
    @Deprecated
    default public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean addAll(@NonNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean addAll(int index, @NonNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean removeAll(@NonNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean retainAll(@NonNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void replaceAll(@NonNull UnaryOperator<E> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void addFirst(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void addLast(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public E removeFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public E removeLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean removeIf(@NonNull Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }
}

