/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.SequencedCollection;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.collections.UnmodifiableSequencedCollection;

final class UnmodifiableSequencedCollectionImpl<E>
implements UnmodifiableSequencedCollection<E> {
    private static final long serialVersionUID = 1L;
    private final SequencedCollection<E> sequencedCollection;

    public UnmodifiableSequencedCollectionImpl(SequencedCollection<E> sequencedCollection) {
        this.sequencedCollection = Collections.unmodifiableSequencedCollection(sequencedCollection);
    }

    @Override
    public UnmodifiableSequencedCollection<E> reversed() {
        return UnmodifiableSequencedCollection.of(this.sequencedCollection.reversed());
    }

    @Override
    public @NonNull UnmodifiableIterator<E> iterator() {
        return UnmodifiableIterator.of(this.sequencedCollection.iterator());
    }

    @Override
    public int size() {
        return this.sequencedCollection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sequencedCollection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.sequencedCollection.contains(o);
    }

    @Override
    public Object @NonNull [] toArray() {
        return this.sequencedCollection.toArray();
    }

    @Override
    public <T> T @NonNull [] toArray(T @NonNull [] a) {
        return this.sequencedCollection.toArray(a);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.sequencedCollection.containsAll(c);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.sequencedCollection.toArray(generator);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.sequencedCollection.spliterator();
    }

    @Override
    public Stream<E> stream() {
        return this.sequencedCollection.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.sequencedCollection.parallelStream();
    }

    @Override
    public E getFirst() {
        return this.sequencedCollection.getFirst();
    }

    @Override
    public E getLast() {
        return this.sequencedCollection.getLast();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.sequencedCollection.forEach(action);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnmodifiableSequencedCollectionImpl) {
            UnmodifiableSequencedCollectionImpl that = (UnmodifiableSequencedCollectionImpl)o;
            return this.sequencedCollection.equals(that.sequencedCollection);
        }
        return this.sequencedCollection.equals(o);
    }

    @Override
    public int hashCode() {
        return this.sequencedCollection.hashCode();
    }

    public String toString() {
        return this.sequencedCollection.toString();
    }
}

