/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableSequencedCollection;
import org.conqat.lib.commons.collections.UnmodifiableSequencedSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.collections.UnmodifiableSortedMap;

final class UnmodifiableSortedMapImpl<K, V>
implements UnmodifiableSortedMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final SortedMap<K, V> sortedMap;

    public UnmodifiableSortedMapImpl(SortedMap<K, V> sortedMap) {
        this.sortedMap = Collections.unmodifiableSortedMap(sortedMap);
    }

    @Override
    public @NonNull UnmodifiableSortedMap<K, V> subMap(K fromKey, K toKey) {
        return UnmodifiableSortedMap.of(this.sortedMap.subMap(fromKey, toKey));
    }

    @Override
    public @NonNull UnmodifiableSortedMap<K, V> headMap(K toKey) {
        return UnmodifiableSortedMap.of(this.sortedMap.headMap(toKey));
    }

    @Override
    public @NonNull UnmodifiableSortedMap<K, V> tailMap(K fromKey) {
        return UnmodifiableSortedMap.of(this.sortedMap.tailMap(fromKey));
    }

    @Override
    public UnmodifiableSortedMap<K, V> reversed() {
        return UnmodifiableSortedMap.of(this.sortedMap.reversed());
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.sortedMap.comparator();
    }

    @Override
    public K firstKey() {
        return this.sortedMap.firstKey();
    }

    @Override
    public K lastKey() {
        return this.sortedMap.lastKey();
    }

    @Override
    public UnmodifiableSequencedSet<K> sequencedKeySet() {
        return UnmodifiableSequencedSet.of(this.sortedMap.sequencedKeySet());
    }

    @Override
    public UnmodifiableSequencedCollection<V> sequencedValues() {
        return UnmodifiableSequencedCollection.of(this.sortedMap.sequencedValues());
    }

    @Override
    public UnmodifiableSequencedSet<Map.Entry<K, V>> sequencedEntrySet() {
        return UnmodifiableSequencedSet.of(this.sortedMap.sequencedEntrySet());
    }

    @Override
    public @NonNull UnmodifiableSet<K> keySet() {
        return UnmodifiableSet.of(this.sortedMap.keySet());
    }

    @Override
    public @NonNull UnmodifiableCollection<V> values() {
        return UnmodifiableCollection.of(this.sortedMap.values());
    }

    @Override
    public @NonNull UnmodifiableSet<Map.Entry<K, V>> entrySet() {
        return UnmodifiableSet.of(this.sortedMap.entrySet());
    }

    @Override
    public int size() {
        return this.sortedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sortedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.sortedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.sortedMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.sortedMap.get(key);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.sortedMap.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.sortedMap.forEach(action);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.sortedMap.firstEntry();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.sortedMap.lastEntry();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnmodifiableSortedMapImpl) {
            UnmodifiableSortedMapImpl that = (UnmodifiableSortedMapImpl)o;
            return this.sortedMap.equals(that.sortedMap);
        }
        return this.sortedMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.sortedMap.hashCode();
    }

    public String toString() {
        return this.sortedMap.toString();
    }
}

