/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.SortedSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.UnmodifiableNavigableSet;
import org.conqat.lib.commons.collections.UnmodifiableSequencedSet;
import org.conqat.lib.commons.collections.UnmodifiableSortedSetImpl;

public sealed interface UnmodifiableSortedSet<E>
extends SortedSet<E>,
UnmodifiableSequencedSet<E>
permits UnmodifiableNavigableSet, UnmodifiableSortedSetImpl {
    public static <E> UnmodifiableSortedSet<E> of(SortedSet<E> sortedSet) {
        if (sortedSet instanceof UnmodifiableSortedSet) {
            UnmodifiableSortedSet unmodifiable = (UnmodifiableSortedSet)sortedSet;
            return unmodifiable;
        }
        return new UnmodifiableSortedSetImpl<E>(sortedSet);
    }

    @Override
    public UnmodifiableSortedSet<E> reversed();

    @Override
    public @NonNull UnmodifiableSortedSet<E> subSet(E var1, E var2);

    @Override
    public @NonNull UnmodifiableSortedSet<E> headSet(E var1);

    @Override
    public @NonNull UnmodifiableSortedSet<E> tailSet(E var1);

    @Override
    @Deprecated
    default public void addFirst(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void addLast(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public E removeFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public E removeLast() {
        throw new UnsupportedOperationException();
    }
}

