/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.date;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.conqat.lib.commons.date.ClockProvider;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DateTimeUtils {
    public static final DateTimeFormatter UI_FORMATTER = DateTimeUtils.createDateTimeFormatter("MMM dd yyyy HH:mm");

    public static Clock getClock() {
        return ClockProvider.getInstance().getClock();
    }

    public static ZoneId getZone() {
        return DateTimeUtils.getClock().getZone();
    }

    public static Instant now() {
        return DateTimeUtils.withClock(Clock::instant);
    }

    public static long millisNow() {
        return DateTimeUtils.getClock().millis();
    }

    public static ZonedDateTime zonedNow() {
        return DateTimeUtils.withClock(ZonedDateTime::now);
    }

    public static <T extends Temporal> T withClock(Function<Clock, T> creator) {
        return (T)((Temporal)creator.apply(DateTimeUtils.getClock()));
    }

    public static ZonedDateTime atZone(Instant instant) {
        return instant.atZone(DateTimeUtils.getZone());
    }

    public static ZonedDateTime atZone(long timestamp) {
        return DateTimeUtils.atZone(Instant.ofEpochMilli(timestamp));
    }

    public static long diff(Instant start, Instant end, TimeUnit timeUnit) {
        long millis = Duration.between(start, end).toMillis();
        return timeUnit.convert(millis, TimeUnit.MILLISECONDS);
    }

    public static DateTimeFormatter createDateTimeFormatter(String pattern) {
        return DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH);
    }

    public static String getUiFormattedDateString(long timestamp) {
        return DateTimeUtils.formatTimestamp(timestamp, UI_FORMATTER);
    }

    public static String getUiFormattedDateStringWithSeconds(long timestamp) {
        return DateTimeUtils.formatTimestamp(timestamp, DateTimeUtils.createDateTimeFormatter("MMM dd yyyy HH:mm:ss"));
    }

    public static String formatTimestamp(long timestamp, DateTimeFormatter formatter) {
        return DateTimeUtils.atZone(timestamp).format(formatter);
    }

    public static boolean hasDurationPassedSince(LocalDateTime dateTimeToCompare, Duration durationBeforeNow) {
        return dateTimeToCompare.isBefore(LocalDateTime.ofInstant(DateTimeUtils.now(), DateTimeUtils.getZone()).minus(durationBeforeNow));
    }

    private DateTimeUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

