/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.conqat.lib.commons.filesystem.PathBasedContentProviderBase;
import org.conqat.lib.commons.filesystem.ZipFile;

final class ZipContentProvider
extends PathBasedContentProviderBase {
    private final ZipFile zipFile;

    public ZipContentProvider(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public Collection<String> getPaths() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration e = this.zipFile.getEntries();
        while (e.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)e.nextElement();
            if (entry.isDirectory()) continue;
            result.add(entry.getName());
        }
        return result;
    }

    @Override
    public InputStream openStream(String relativePath) throws IOException {
        ZipArchiveEntry entry = this.zipFile.getEntry(relativePath);
        if (entry == null) {
            throw new IOException("Unknown path: " + relativePath);
        }
        return this.zipFile.getInputStream(entry);
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }
}

