/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.io.ProcessUtils;

class StreamConsumingThread
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger();
    private final InputStream inputStream;
    private final ProcessUtils.IStreamConsumer streamConsumer;
    private final AtomicBoolean propagation = new AtomicBoolean(true);
    private final CountDownLatch latch = new CountDownLatch(1);

    StreamConsumingThread(InputStream inputStream, ProcessUtils.IStreamConsumer streamConsumer) {
        this.inputStream = inputStream;
        this.streamConsumer = streamConsumer;
        this.start();
    }

    public void stopPropagation() throws InterruptedException {
        this.propagation.set(false);
        this.latch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        try (InputStream controlledInputStream = new ControlledInputStream(this.inputStream);){
            this.streamConsumer.consume(controlledInputStream);
        }
        catch (IOException e) {
            LOGGER.warn("Encountered IOException during stream consumption", (Throwable)e);
        }
        finally {
            this.latch.countDown();
            try (InputStream inputStream = this.inputStream;){
                this.consumeRemainingStream();
            }
            catch (IOException iOException) {}
        }
    }

    private void consumeRemainingStream() throws IOException {
        byte[] buffer = new byte[1024];
        while (this.inputStream.read(buffer) != -1) {
        }
    }

    private class ControlledInputStream
    extends FilterInputStream {
        private boolean streamClosed;

        protected ControlledInputStream(InputStream in) {
            super(in);
            this.streamClosed = false;
        }

        @Override
        public int read() throws IOException {
            if (this.streamClosed) {
                throw new IOException("Stream already closed.");
            }
            return StreamConsumingThread.this.propagation.get() ? super.read() : -1;
        }

        @Override
        public int read(byte @NonNull [] b, int off, int len) throws IOException {
            if (this.streamClosed) {
                throw new IOException("Stream already closed.");
            }
            return StreamConsumingThread.this.propagation.get() ? super.read(b, off, len) : -1;
        }

        @Override
        public void close() {
            this.streamClosed = true;
        }
    }
}

