/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.lang;

import java.util.Comparator;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ObjectUtils {
    public static <T extends Comparable<T>> int compareNullSafe(@Nullable T object1, @Nullable T object2) {
        return ObjectUtils.compareNullSafe(object1, object2, Comparable::compareTo);
    }

    private static <T> int compareNullSafe(@Nullable T object1, @Nullable T object2, Comparator<T> comparator) {
        if (object1 == object2) {
            return 0;
        }
        if (object1 == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return comparator.compare(object1, object2);
    }

    public static <T, E extends Exception> T requireNonNullElseThrow(@Nullable T reference, Supplier<E> exceptionSupplier) throws E {
        if (reference == null) {
            throw (Exception)exceptionSupplier.get();
        }
        return reference;
    }

    private ObjectUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

