/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.resources;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nonapi.io.github.classgraph.scanspec.AcceptReject;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.ClassPathUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ResourceUtils {
    private static final Set<String> ALLOWED_CLASSPATH_PREFIXES = CollectionUtils.asHashSet("org.conqat", "com.teamscale", "eu.cqse");

    public static List<Resource> listResources(Class<?> contextClass, String path) {
        return ResourceUtils.listResources(contextClass, path, false);
    }

    public static List<Resource> listResourcesRecursively(Class<?> contextClass, String path) {
        return ResourceUtils.listResources(contextClass, path, true);
    }

    public static String getPackageResourcePath(Class<?> contextClass) {
        return contextClass.getPackage().getName().replace('.', '/');
    }

    private static List<Resource> listResources(Class<?> contextClass, String path, boolean recursive) {
        return CollectionUtils.map(ResourceUtils.listResourceNames(contextClass, path, recursive), resourcePath -> Resource.of(contextClass, resourcePath));
    }

    private static List<String> listResourceNames(Class<?> contextClass, String path, boolean recursive) {
        String packageName = contextClass.getPackage().getName();
        String contextPath = AcceptReject.packageNameToPath((String)packageName);
        String fullPath = ResourceUtils.determineAbsoluteResourcePath(contextPath, path);
        ClassGraph classGraph = new ClassGraph();
        List<String> classPathOverride = ResourceUtils.getFilteredClassPath(contextClass, packageName);
        if (!classPathOverride.isEmpty()) {
            classGraph = classGraph.overrideClasspath(classPathOverride);
        }
        classGraph = recursive ? classGraph.acceptPaths(new String[]{fullPath}) : classGraph.acceptPathsNonRecursive(new String[]{fullPath});
        HashSet resources = new HashSet();
        try (ScanResult scanResult = classGraph.scan();){
            scanResult.getAllResources().nonClassFilesOnly().forEach(res -> {
                String resourceFullPath = res.getPath();
                if (path.startsWith("/")) {
                    resources.add("/" + resourceFullPath);
                } else {
                    resources.add(StringUtils.stripPrefix(resourceFullPath, contextPath + "/"));
                }
            });
        }
        return new ArrayList<String>(resources);
    }

    private static boolean isClassInAllowedPrefixes(Class<?> contextClass) {
        return ALLOWED_CLASSPATH_PREFIXES.contains(StringUtils.getFirstParts(contextClass.getName(), 2, '.'));
    }

    private static List<String> getFilteredClassPath(Class<?> contextClass, String packageName) {
        List<String> classpathEntries = ClassPathUtils.getClassPathEntries();
        if (!ResourceUtils.isClassInAllowedPrefixes(contextClass)) {
            String packagePrefix = StringUtils.getFirstParts(packageName, 3, '.');
            return CollectionUtils.filter(classpathEntries, classpathEntry -> classpathEntry.contains(packagePrefix));
        }
        return CollectionUtils.filter(classpathEntries, classpathEntry -> StringUtils.containsOneOf(classpathEntry, ALLOWED_CLASSPATH_PREFIXES));
    }

    private static String determineAbsoluteResourcePath(String contextPath, String path) {
        if (path.startsWith("/")) {
            return path;
        }
        Object fullPath = contextPath;
        if (!StringUtils.isEmpty(path)) {
            fullPath = (String)fullPath + "/" + path;
        }
        return fullPath;
    }

    private ResourceUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

