/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.wia;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.wia.EWorkItemType;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ManualTestCase
extends SpecItem {
    private static final long serialVersionUID = 1L;
    public static final String TEST_STEPS_JSON_PROPERTY_NAME = "testSteps";
    @JsonProperty(value="testSteps")
    private final List<TestStep> testSteps;

    public ManualTestCase(SpecItem specItem, List<TestStep> testSteps) {
        super(specItem);
        this.testSteps = new ArrayList<TestStep>(testSteps);
    }

    public ManualTestCase(TeamscaleIssueId id, long created, String assignee, String subject, List<TestStep> testSteps) {
        super(id, created, assignee, subject);
        this.testSteps = new ArrayList<TestStep>(testSteps);
    }

    @JsonCreator
    public ManualTestCase(@JsonProperty(value="id") TeamscaleIssueId id, @JsonProperty(value="subject") String subject, @JsonProperty(value="assignee") String assignee, @JsonProperty(value="author") String author, @JsonProperty(value="description") String description, @JsonProperty(value="created") long created, @JsonProperty(value="updated") long updated, @JsonProperty(value="status") String status, @JsonProperty(value="closed") boolean closed, @JsonProperty(value="url") String url, @JsonProperty(value="additionalFieldNames") List<String> additionalFieldNames, @JsonProperty(value="additionalFieldValues") List<String> additionalFieldValues, @JsonProperty(value="parentId") TeamscaleIssueId parentId, @JsonProperty(value="additionalAssignees") List<String> additionalAssignees, @JsonProperty(value="additionalFieldTypes") List<String> additionalFieldTypes, @JsonProperty(value="additionalParents") List<TeamscaleIssueId> additionalParents, @JsonProperty(value="linkRoles") List<String> linkRoles, @JsonProperty(value="linkedSpecItems") List<List<TeamscaleIssueId>> linkedSpecItems, @JsonProperty(value="type") String type, @JsonProperty(value="typeAbbreviation") String typeAbbreviation, @JsonProperty(value="testSteps") List<TestStep> testSteps) {
        super(id, subject, assignee, author, description, created, updated, status, closed, url, additionalFieldNames, additionalFieldValues, parentId, additionalAssignees, additionalFieldTypes, additionalParents, linkRoles, linkedSpecItems, type, typeAbbreviation);
        this.testSteps = testSteps;
    }

    public ManualTestCase(ManualTestCase testCase) {
        super(testCase);
        this.testSteps = new ArrayList<TestStep>(testCase.testSteps);
    }

    @Override
    public ManualTestCase copy() {
        return new ManualTestCase(this);
    }

    @Override
    public EWorkItemType getWorkItemType() {
        return EWorkItemType.TEST_ITEM;
    }

    public UnmodifiableList<TestStep> getTestSteps() {
        return CollectionUtils.asUnmodifiable(this.testSteps);
    }

    public TestStep getTestStep(int index) {
        return this.testSteps.get(index);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ManualTestCase that = (ManualTestCase)o;
        return Objects.equals(this.testSteps, that.testSteps);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.testSteps);
    }

    @IndexValueClass(containedInBackup=true)
    public static class TestStep
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="action")
        private final String action;
        @JsonProperty(value="check")
        private final String check;

        @JsonCreator
        public TestStep(@JsonProperty(value="action") String action, @JsonProperty(value="check") String check) {
            this.action = action;
            this.check = check;
        }

        public static TestStep ofAction(String action) {
            return new TestStep(action, "");
        }

        public static TestStep ofCheck(String check) {
            return new TestStep("", check);
        }

        public String getAction() {
            return this.action;
        }

        public String getCheck() {
            return this.check;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestStep testStep = (TestStep)o;
            return Objects.equals(this.action, testStep.action) && Objects.equals(this.check, testStep.check);
        }

        public int hashCode() {
            return Objects.hash(this.action, this.check);
        }

        public String toString() {
            return "TestStep{action='" + this.action + "', check='" + this.check + "'}";
        }
    }
}

