/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.badge;

import com.teamscale.service.framework.badge.SvgUtils;
import jakarta.ws.rs.InternalServerErrorException;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.resources.ResourceException;
import org.conqat.lib.commons.string.StringUtils;

public abstract class BadgeCreatorBase {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(.+?)}");
    private static final String INFO_BADGE_TEMPLATE_FILENAME = "info-badge-template.svg";
    private static final int MIN_INFO_BADGE_WIDTH = 90;
    private static final int MAX_INFO_BADGE_TEXT_LENGTH = 50;
    private static final Font FONT = SvgUtils.determineFont();
    private static final Map<String, String> CACHED_SVG_TEMPLATES = new HashMap<String, String>();

    protected String createBadge(String templateFilename, Map<String, String> placeholders) throws InternalServerErrorException {
        return BadgeCreatorBase.replacePlaceholders(BadgeCreatorBase.getSvgTemplate(templateFilename, this.getClass()), placeholders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getSvgTemplate(String templateFilename, Class<?> contextClass) {
        Map<String, String> map = CACHED_SVG_TEMPLATES;
        synchronized (map) {
            if (!CACHED_SVG_TEMPLATES.containsKey(templateFilename)) {
                String templateSvg;
                try {
                    templateSvg = Resource.of(contextClass, (String)templateFilename).getContent();
                }
                catch (ResourceException e) {
                    throw new InternalServerErrorException("Could not load SVG template file.", (Throwable)e);
                }
                CACHED_SVG_TEMPLATES.put(templateFilename, templateSvg);
            }
        }
        return CACHED_SVG_TEMPLATES.get(templateFilename);
    }

    private static String replacePlaceholders(String svgTemplate, Map<String, String> replacements) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(svgTemplate);
        StringBuilder builder = new StringBuilder();
        HashSet<String> successfulReplacements = new HashSet<String>();
        while (matcher.find()) {
            String replacement = "";
            String templateVariableName = matcher.group(1);
            if (replacements.containsKey(templateVariableName)) {
                replacement = replacements.get(templateVariableName);
                successfulReplacements.add(templateVariableName);
            }
            matcher.appendReplacement(builder, replacement);
        }
        if (replacements.size() != successfulReplacements.size()) {
            String missingTemplateVariables = replacements.keySet().stream().filter(element -> !successfulReplacements.contains(element)).collect(Collectors.joining(", "));
            throw new IllegalStateException("Could not replace [" + missingTemplateVariables + "] of " + replacements.size() + " template replacements.");
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    protected static int computeTextWidth(String text) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        Rectangle2D textRectangle = FONT.getStringBounds(text, frc);
        return (int)Math.ceil(textRectangle.getWidth());
    }

    protected static String svgRectanglePath(int startX, int width) {
        return "M" + startX + " 0 h" + width + " v20 h-" + width + " z";
    }

    public static byte[] createUnauthorizedBadge() {
        return StringUtils.stringToBytes((String)BadgeCreatorBase.getInfoBadge("Not Authorized", "orange"));
    }

    public static byte[] createErrorBadgeWithMessage(String message) {
        return StringUtils.stringToBytes((String)BadgeCreatorBase.getInfoBadge(message, "red"));
    }

    public static byte[] createUnknownIssueBadge() {
        return StringUtils.stringToBytes((String)BadgeCreatorBase.getInfoBadge("Unknown Issue", "orange"));
    }

    public static byte[] createInsufficientRightsBadge() {
        return StringUtils.stringToBytes((String)BadgeCreatorBase.getInfoBadge("Forbidden", "red"));
    }

    private static String getInfoBadge(String text, String color) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        String svg = BadgeCreatorBase.getSvgTemplate(INFO_BADGE_TEMPLATE_FILENAME, BadgeCreatorBase.class);
        String truncatedText = StringUtils.truncateWithThreeDots((String)text, (int)50);
        int width = BadgeCreatorBase.determineInfoBadgeWidth(truncatedText);
        replacements.put("rect_width", String.valueOf(width));
        replacements.put("rect_path", BadgeCreatorBase.svgRectanglePath(0, width));
        replacements.put("text_offset_x", String.valueOf((double)width * 1.0 / 2.0));
        replacements.put("text", truncatedText);
        replacements.put("color", color);
        return BadgeCreatorBase.replacePlaceholders(svg, replacements);
    }

    private static int determineInfoBadgeWidth(String text) {
        return Math.max(90, BadgeCreatorBase.computeTextWidth(text));
    }
}

