/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

public class ProgressReport
implements Runnable {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final long period;
    private Supplier<String> messageSupplier = () -> "";
    private final Thread thread;
    private String stopMessage = null;
    private volatile boolean stop = false;

    public ProgressReport(String threadName, long period) {
        this.period = period;
        this.thread = new Thread((Runnable)this, threadName);
        this.thread.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                Thread.sleep(this.period);
                ProgressReport.log(this.messageSupplier.get());
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (this.stopMessage != null) {
            ProgressReport.log(this.stopMessage);
        }
    }

    public void start(String startMessage) {
        ProgressReport.log(startMessage);
        this.thread.start();
    }

    public void message(Supplier<String> messageSupplier) {
        this.messageSupplier = messageSupplier;
    }

    public void stop(@Nullable String stopMessage) {
        this.stopMessage = stopMessage;
        this.stop = true;
        this.thread.interrupt();
        try {
            this.thread.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void log(String message) {
        LOG.info(message);
    }
}

