/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.branch;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

public class GitUtils {
    private static final SonarLintLogger LOG = SonarLintLogger.get();

    private GitUtils() {
    }

    @CheckForNull
    public static Repository getRepositoryForDir(Path projectDir) {
        try {
            RepositoryBuilder builder = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().findGitDir(projectDir.toFile())).setMustExist(true);
            if (builder.getGitDir() == null) {
                LOG.error("Not inside a Git work tree: " + projectDir);
                return null;
            }
            return builder.build();
        }
        catch (IOException e) {
            LOG.error("Couldn't access repository for path " + projectDir, e);
            return null;
        }
    }

    @CheckForNull
    public static String electBestMatchingServerBranchForCurrentHead(Repository repo, Set<String> serverCandidateNames, @Nullable String serverMainBranch) {
        try {
            String currentBranch = repo.getBranch();
            if (currentBranch != null && serverCandidateNames.contains(currentBranch)) {
                return currentBranch;
            }
            Ref head = repo.exactRef("HEAD");
            if (head == null) {
                return null;
            }
            HashMap<Integer, Set> branchesPerDistance = new HashMap<Integer, Set>();
            for (String serverBranchName : serverCandidateNames) {
                String shortBranchName = Repository.shortenRefName((String)serverBranchName);
                String localFullBranchName = "refs/heads/" + shortBranchName;
                Ref branchRef = repo.exactRef(localFullBranchName);
                if (branchRef == null) continue;
                int distance = GitUtils.distance(repo, head, branchRef);
                branchesPerDistance.computeIfAbsent(distance, d -> new HashSet()).add(serverBranchName);
            }
            if (branchesPerDistance.isEmpty()) {
                return null;
            }
            int minDistance = (Integer)branchesPerDistance.keySet().stream().min(Comparator.naturalOrder()).get();
            Set bestCandidates = (Set)branchesPerDistance.get(minDistance);
            if (serverMainBranch != null && bestCandidates.contains(serverMainBranch)) {
                return serverMainBranch;
            }
            return (String)bestCandidates.iterator().next();
        }
        catch (IOException e) {
            LOG.error("Couldn't find best matching branch", e);
            return null;
        }
    }

    private static int distance(Repository repository, Ref from, Ref to) throws IOException {
        try (RevWalk walk = new RevWalk(repository);){
            RevCommit fromCommit = walk.parseCommit((AnyObjectId)from.getObjectId());
            RevCommit toCommit = walk.parseCommit((AnyObjectId)to.getObjectId());
            walk.setRevFilter(RevFilter.MERGE_BASE);
            walk.markStart(fromCommit);
            walk.markStart(toCommit);
            RevCommit mergeBase = walk.next();
            walk.reset();
            walk.setRevFilter(RevFilter.ALL);
            int aheadCount = RevWalkUtils.count((RevWalk)walk, (RevCommit)fromCommit, (RevCommit)mergeBase);
            int behindCount = RevWalkUtils.count((RevWalk)walk, (RevCommit)toCommit, (RevCommit)mergeBase);
            int n = aheadCount + behindCount;
            return n;
        }
    }
}

