/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.nio.file.Path;
import org.sonarsource.sonarlint.core.serverconnection.AnalyzerConfigurationStorage;
import org.sonarsource.sonarlint.core.serverconnection.ComponentsStorage;
import org.sonarsource.sonarlint.core.serverconnection.ProjectBranchesStorage;
import org.sonarsource.sonarlint.core.serverconnection.storage.NewCodeDefinitionStorage;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProjectServerIssueStore;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProjectStoragePaths;
import org.sonarsource.sonarlint.core.serverconnection.storage.ServerIssueStoresManager;
import org.sonarsource.sonarlint.core.serverconnection.storage.SmartNotificationsStorage;

public class SonarProjectStorage {
    private final ServerIssueStoresManager serverIssueStoresManager;
    private final String sonarProjectKey;
    private final AnalyzerConfigurationStorage analyzerConfigurationStorage;
    private final ProjectBranchesStorage projectBranchesStorage;
    private final ComponentsStorage componentsStorage;
    private final SmartNotificationsStorage smartNotificationsStorage;
    private final NewCodeDefinitionStorage newCodeDefinitionStorage;
    private final Path projectStorageRoot;

    public SonarProjectStorage(Path projectsStorageRoot, ServerIssueStoresManager serverIssueStoresManager, String sonarProjectKey) {
        this.projectStorageRoot = projectsStorageRoot.resolve(ProjectStoragePaths.encodeForFs(sonarProjectKey));
        this.serverIssueStoresManager = serverIssueStoresManager;
        this.sonarProjectKey = sonarProjectKey;
        this.analyzerConfigurationStorage = new AnalyzerConfigurationStorage(this.projectStorageRoot);
        this.projectBranchesStorage = new ProjectBranchesStorage(this.projectStorageRoot);
        this.componentsStorage = new ComponentsStorage(this.projectStorageRoot);
        this.smartNotificationsStorage = new SmartNotificationsStorage(this.projectStorageRoot);
        this.newCodeDefinitionStorage = new NewCodeDefinitionStorage(this.projectStorageRoot);
    }

    public ProjectServerIssueStore findings() {
        return this.serverIssueStoresManager.get(this.sonarProjectKey);
    }

    public AnalyzerConfigurationStorage analyzerConfiguration() {
        return this.analyzerConfigurationStorage;
    }

    public ProjectBranchesStorage branches() {
        return this.projectBranchesStorage;
    }

    public ComponentsStorage components() {
        return this.componentsStorage;
    }

    public SmartNotificationsStorage smartNotifications() {
        return this.smartNotificationsStorage;
    }

    public NewCodeDefinitionStorage newCodeDefinition() {
        return this.newCodeDefinitionStorage;
    }

    public Path filePath() {
        return this.projectStorageRoot;
    }
}

