/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.push.ServerEvent;
import org.sonarsource.sonarlint.core.serverconnection.events.ServerEventHandler;

public class EventDispatcher
implements ServerEventHandler<ServerEvent> {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Map<Class<?>, List<ServerEventHandler>> routes = new HashMap();

    public <E extends ServerEvent> EventDispatcher dispatch(Class<E> eventType, ServerEventHandler<E> handler) {
        this.routes.computeIfAbsent(eventType, k -> new ArrayList()).add(handler);
        return this;
    }

    @Override
    public void handle(ServerEvent event) {
        Class<?> eventType = event.getClass();
        if (this.routes.containsKey(eventType)) {
            this.routes.get(eventType).forEach(handler -> handler.handle(event));
        } else {
            LOG.error("No handler for event '{}'", (Object)eventType);
        }
    }
}

