/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.websocket;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class History {
    private final Map<String, Instant> receivedMessages = new ConcurrentHashMap<String, Instant>();

    public void recordMessage(String message) {
        this.receivedMessages.put(message, Instant.now());
    }

    public boolean exists(String message) {
        return this.receivedMessages.containsKey(message);
    }

    public void forgetOlderThan(Duration expiryDuration) {
        Instant now = Instant.now();
        this.receivedMessages.values().removeIf(messageDate -> messageDate.isBefore(now.minus(expiryDuration)));
    }
}

