/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.documentation;

import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.security.SecuritySettingsUtils;
import com.teamscale.ui.TeamscaleStarter;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

@Hidden
@Path(value="documentation")
public class DocumentationService
extends ApiBase {
    private static final String DOCUMENTATION_DIRECTORY = "documentation/";
    private static final int DOCUMENTATION_CACHE_SECONDS = 36000;
    private static final Pattern HREF_SRC_OR_BASE = Pattern.compile("( (href|src)=[\"']|\\\\\"base\\\\\":\\\\\")/");
    private static final String META_INF_DOCUMENTATION = "/META-INF/documentation/";

    @Operation(summary="Browse the Teamscale documentation")
    @GET
    @RequiresNoLogin
    @Path(value="{path: .*}")
    @Cache(maxAge=36000)
    public Response getDocsContent(@PathParam(value="path") String path) throws NoSuchAlgorithmException {
        if ("".equals(StringUtils.getLastPart((String)path, (char)'/'))) {
            path = (String)path + "index.html";
        } else {
            if (this.getResource((String)path + "/index.html").isPresent()) {
                return Response.temporaryRedirect((URI)this.createRedirectUri(DOCUMENTATION_DIRECTORY + (String)path + "/")).build();
            }
            if (this.getResource((String)path + ".html").isPresent()) {
                path = (String)path + ".html";
            }
        }
        Optional<Resource> resource = this.getResource((String)path);
        if (resource.isPresent()) {
            return this.appendPatchedResource(Response.ok(), resource.get());
        }
        Optional<Resource> resource404 = this.getResource("404.html");
        if (resource404.isPresent()) {
            return this.appendPatchedResource(Response.status((Response.Status)Response.Status.NOT_FOUND), resource404.get());
        }
        throw new InternalServerErrorException("Could not find documentation at expected location!");
    }

    private Optional<Resource> getResource(String path) {
        File docsRoot = TeamscaleStarter.getDocsProjectRoot();
        if (docsRoot != null) {
            try {
                File file = new File(new File(docsRoot, "build/dist"), path);
                if (file.isFile()) {
                    return Optional.of(Resource.of(((Object)((Object)this)).getClass(), (String)path, (URL)file.toURI().toURL()));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return Resource.asOptional(((Object)((Object)this)).getClass(), (String)(META_INF_DOCUMENTATION + path));
    }

    private Response appendPatchedResource(Response.ResponseBuilder builder, Resource resource) throws NoSuchAlgorithmException {
        String extension = FileSystemUtils.getFileExtension((String)resource.getName());
        MediaType mediaType = (MediaType)MoreMediaTypes.EXTENSIONS.getOrDefault((Object)extension, (Object)MediaType.APPLICATION_OCTET_STREAM_TYPE);
        if (!DocumentationService.needsToBePatched(resource)) {
            return builder.entity((Object)resource.getAsByteArray()).type(mediaType).build();
        }
        String content = resource.getContentAsRawString();
        String location = this.getLocationPrefix();
        if (resource.hasExtension(new String[]{"html"})) {
            content = HREF_SRC_OR_BASE.matcher(content).replaceAll("$1" + Matcher.quoteReplacement(location));
            Matcher matcher = Pattern.compile("<script\\b[^>]*>(.*?)</script>", 32).matcher(content);
            while (matcher.find()) {
                String script = matcher.group(1);
                SecuritySettingsUtils.allowScript((Response.ResponseBuilder)builder, (String)script);
            }
            SecuritySettingsUtils.allowUnsafeEval((Response.ResponseBuilder)builder);
            return builder.entity((Object)StringUtils.stringToBytes((String)content)).type(mediaType).build();
        }
        if (resource.hasExtension(new String[]{"css"})) {
            content = content.replaceAll("(url\\()/(?=assets)", "$1" + Matcher.quoteReplacement(location));
        } else if (resource.hasExtension(new String[]{"js"})) {
            content = content.replace("=\"/", "=\"" + location);
            content = content.replace("link:\"/", "link:\"" + location);
            if (resource.getName().contains("@localSearch")) {
                content = content.replaceAll("(\"\\d+\":\")/", "$1" + Matcher.quoteReplacement(location));
            }
            content = content.replace("return\"/", "return\"" + location);
        } else if (resource.getName().equals("manifest.json")) {
            content = content.replace("\"src\": \"/", "\"src\": \"" + location);
        }
        return builder.entity((Object)StringUtils.stringToBytes((String)content)).type(mediaType).build();
    }

    private String getLocationPrefix() {
        return this.createRedirectUri(DOCUMENTATION_DIRECTORY).getPath();
    }

    private static boolean needsToBePatched(Resource resource) {
        return resource.hasExtension(new String[]{"html", "css", "js"}) || resource.getName().equals("manifest.json");
    }
}

