/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface IOperatorInformation {
    public List<Set<ETokenType>> operatorsByPrecedence();

    default public Set<ETokenType> unaryOperators() {
        return Set.of(ETokenType.PLUS, ETokenType.MINUS, ETokenType.NOT, ETokenType.COMP, ETokenType.BIT_NOT);
    }

    default public Set<ETokenType> allOpeningTypes() {
        return Set.of(ETokenType.LPAREN, ETokenType.LBRACK, ETokenType.LBRACE);
    }

    default public Set<ETokenType> allClosingTypes() {
        return Set.of(ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE);
    }

    default public List<ETokenType> openingTypes() {
        return List.of(ETokenType.LPAREN);
    }

    default public List<ETokenType> closingTypes() {
        return List.of(ETokenType.RPAREN);
    }

    default public Set<ETokenType> associativeOperators() {
        return Set.of(ETokenType.OROR, ETokenType.ANDAND, ETokenType.PLUS, ETokenType.MULT, ETokenType.EQEQ, ETokenType.AND, ETokenType.OR, ETokenType.XOR);
    }

    default public boolean isAssociative(ETokenType operator) {
        return operator != null && this.associativeOperators().contains(operator);
    }

    default public Set<ETokenType> commutativeOperators() {
        return Set.of(ETokenType.OROR, ETokenType.ANDAND, ETokenType.PLUS, ETokenType.MULT, ETokenType.EQEQ, ETokenType.AND, ETokenType.OR, ETokenType.XOR);
    }

    default public boolean isCommutative(ETokenType operator) {
        return operator != null && this.commutativeOperators().contains(operator);
    }

    default public Set<ETokenType> getAllOperators() {
        HashSet<ETokenType> operators = new HashSet<ETokenType>();
        for (Set<ETokenType> precedenceLevel : this.operatorsByPrecedence()) {
            operators.addAll(precedenceLevel);
        }
        return operators;
    }

    default public Set<List<ETokenType>> getAllowedEmptyCollections() {
        return Set.of();
    }

    default public List<IToken> preprocessTokens(List<IToken> tokens) {
        return new ArrayList<IToken>(tokens);
    }
}

